/* gmoo - a gtk+ based graphical MOO/MUD/MUSH/... client
 * Copyright (C) 1999-2000 Gert Scholten
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef GM_MCP_H
#define GM_MCP_H

#include "config.h"
#include "world.h"

typedef struct _mcp_multiline mcp_multiline;
typedef struct _mcp_version   mcp_version;

typedef void (* multiline_line_f) (mcp_multiline *m,
                                   const char *name, const char *line);
typedef void (* multiline_end_f)  (mcp_multiline *m);

typedef void (* package_init_f)   (mcp_package *p);
typedef void (* package_handle_f) (mcp_package *p, const char *command,
                                   int argc, char **argv);
typedef void (* package_free_f)   (mcp_package *p);

struct _mcp_version {
    int major;
    int minor;
};

struct _mcp_session {
    world *belongs_to;
    char *key;
    mcp_version version;
    GList *packages;
    GList *multilines;
};

struct _mcp_package {
    char *name;		       /* name the the package */
    mcp_version       version; /* Version of protocoll */
    mcp_session      *session; /* pointer to the mcp_session of the world */
    package_handle_f  handle;  /* function that handles package functions */
    package_free_f    free;    /* function that frees the package data structure*/
    void *data;                /* pointer to package specific information */
};

struct _mcp_multiline {
    char *key;
    void *data;
    mcp_package *belongs_to;
    multiline_line_f line;
    multiline_end_f  end;
};

void gm_mcp_open_for_world(world *w, const char *line, int len);
void gm_mcp_handle(mcp_session *s, const char *line, int len);
void gm_mcp_close(mcp_session *s);
void gm_mcp_add_package(mcp_session *s, mcp_package *p);
void gm_mcp_send(mcp_session *s,
                 const char *name, const char *func, const char *args);
void gm_mcp_multiline_send(mcp_session *s, const char *key, const char *name,
                           const char *line, int has_newline);
void gm_mcp_multiline_end(mcp_session *s, const char *key);
void gm_mcp_multiline_new(mcp_package *p,
                          const char *key,
                          void *data,
                          multiline_line_f handle_line,
                          multiline_end_f  handle_end);

#endif /* GM_MCP_H */
