/* gmoo - a gtk+ based graphical MOO/MUD/MUSH/... client
 * Copyright (C) 1999-2000 Gert Scholten
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#ifndef GM_SCRIPT_H
#define GM_SCRIPT_H

#include "config.h"

#if defined PERL || defined TCL
#   define SCRIPT
#include "world.h"

#define PERL_TYPE 1
#define TCL_TYPE  2

void gm_script_init(const char *programname);
void gm_script_exit();
int  gm_script_handle_macro(world *w, const char *line);

void gm_script_world_opened      (world *w);
void gm_script_world_closed      (world *w);
void gm_script_world_connected   (world *w);
void gm_script_world_disconnected(world *w);

/* internal script handlers
 */

/* These return TRUE on success and FALSE on an error
 * If there is a return value required, it will be in the
 * `retval' param and must not bee free()d
 */
int gm_script_do_print  (int id, const char *text);
int gm_script_do_println(int id, const char *text);
int gm_script_do_msg    (int id, const char *text);
int gm_script_do_write  (int id, const char *text);
int gm_script_do_writeln(int id, const char *text);

int gm_script_do_name     (int id, char **retval);
int gm_script_do_hostname (int id, char **retval);
int gm_script_do_port     (int id, int *retval);
int gm_script_do_connected(int id, int *retval);
int gm_script_do_width    (int id, int *retval);
int gm_script_do_height   (int id, int *retval);

int gm_script_do_register_open      (int script_type, const char *name);
int gm_script_do_register_close     (int script_type, const char *name);
int gm_script_do_register_connect   (int script_type, const char *name);
int gm_script_do_register_disconnect(int script_type, const char *name);

int gm_script_do_register_macro(int script_type,
				const char *macroname,
				const char *funcname,
				const char *description);
int gm_script_do_register_start(int script_type,
				const char *name);
int gm_script_do_register_end  (int script_type,
				const char *name);
int gm_script_do_version       (char **retval);
int gm_script_do_msgbox        (const char *title,
				const char *type,
				const char *buttons,
				const char *text,
				int default_button,
				int *retval);
#define TYPE_INT 1
#define TYPE_STR 2
int gm_script_do_input(const char *title, const char *description,
		       const char *type_str, int *type_int,
		       const char *def,
		       char **ret_str, int *ret_int);

#endif /* PERL || TCL */

#endif /* GM_TCL_H */
