.TH MAKECPT l "1 Nov 2006" "GMT4.1.4" "GMT4.1.4"
.SH NAME
makecpt \- Make GMT color palette tables
.SH SYNOPSIS
\fBmakecpt\fP [ \fB\-C\fP\fItable\fP ] [ \fB\-D\fP ]  [ \fB\-I\fP ] [ \fB\-M\fP ] [ \fB\-N\fP ]
[ \fB\-Q\fP[\fBi|o\fP] ] [ \fB\-T\fP\fIz0/z1/dz\fP | \fB\-T\fP\fIztable\fP] [ \fB\-V\fP ] [ \fB\-Z\fP ]
.SH DESCRIPTION
\fBmakecpt\fP is a utility that will help you make color palette tables (cpt files).  You define
an equidistant set of contour intervals or pass your own z-table, and create a new cpt file based on
an existing master cpt file.  The resulting cpt file can be reversed relative
to the master cpt, and can be made continuous or discrete.
.br
The color palette includes three additional colors beyond the range of z-values. These are
the background color (B) assigned to values lower than the lowest \fIz\fP-value,
the foreground color (F) assigned to values higher than the highest \fIz\fP-value,
and the NaN color (N) painted whereever values are undefined.
.br
If the master cpt file includes B, F, and N entries, these will be copied into the new master file.
If not, the parameters \fBCOLOR_BACKGROUND\fP, \fBCOLOR_FOREGROUND\fP, and \fBCOLOR_NAN\fP from
the .gmtdefaults4 file or the command line will be used. This default behavior can be overruled
using the options \fB\-D\fP, \fB\-M\fP or \fB\-N\fP.
.br
The color model (RGB, HSV or CMYK) of the palette created by \fBmakecpt\fP will be the same as
specified in the header of the master cpt file. When there is no \fBCOLOR_MODEL\fP entry in the
master cpt file, the \fBCOLOR_MODEL\fP specified in the .gmtdefaults4 file or on the command line
will be used.
.SH OPTIONS
.TP
.B \-C
Selects the master color table \fItable\fP to use in the interpolation.
Choose among the built-in tables (type \fBmakecpt\fP to see the list) or
give the name of an existing cpt file [Default gives a rainbow cpt file].
.TP
.B \-D
Select the colors for lowest and highest \fIz\fP-values in the output cpt file
as the back- and foreground colors that will be written to the cpt file [Default uses
the colors specified in the master file, or those defined by 
the parameters \fBCOLOR_BACKGROUND\fP, \fBCOLOR_FOREGROUND\fP, and \fBCOLOR_NAN\fP].
.TP
.B \-I
Reverses the sense of color progression in the master cpt file.
Also exchanges the foreground and background colors, including those specified by
the parameters \fBCOLOR_BACKGROUND\fP and \fBCOLOR_FOREGROUND\fP.
.TP
.B \-M
Overrule background, foreground, and NaN colors specified in the master cpt file with the values of
the parameters \fBCOLOR_BACKGROUND\fP, \fBCOLOR_FOREGROUND\fP, and \fBCOLOR_NAN\fP specified in
the .gmtdefaults4 file or on the command line.
When combined with \fB\-D\fP, only \fBCOLOR_NAN\fP is considered.
.TP
.B \-N
Do not write out the background, foreground, and NaN-color fields [Default will write them].
.TP
.B \-Q
Selects a logarithmic interpolation scheme [Default is linear].  \fB\-Qi\fP
expects input z-values to be log10(z), assigns colors, and writes out z
[Default].  \fB\-Qo\fP takes log10(z) first, assigns colors, and writes out z.
.TP
.B \-T
Defines the range of the new cpt file by giving the lowest and highest z-value
and the interval.  Alternatively, give the name of a ASCII file that has one
z-value per record.  If not given, the existing range in the master cpt file
will be used intact.
.TP
.B \-V
Selects verbose mode, which will send progress reports to stderr [Default runs "silently"].
.TP
.B \-Z
Creates a continuous cpt file [Default is discontinuous, i.e. constant colors
for each interval].
.SH EXAMPLES
To make a cpt file with z-values from -200 to 200, with discrete color changes every
25, and using a polar blue-white-red colortable:
.br
.sp
\fBmakecpt\fP \fB\-C\fP\fIpolar\fP \fB\-T\fP-200/200/25 > colors.cpt
.br
.sp
To make an equidistant cpt file from z = -2 to 6, in steps of 1, using
continuous default rainbow colors:
.br
.sp
\fBmakecpt\fP \fB\-T\fP-2/6/1 \fB\-Z\fP > rainbow.cpt
.br
.sp
To make a GEBCO look-alike cpt file for bathymetry, run
.br
.sp
\fBmakecpt\fP \fB\-C\fPgebco > my_gebco.cpt
.SH BUGS
Since \fBmakecpt\fP will also interpolate from any existing .cpt file you
may have in your directory, you cannot use one of the listed cpt names
as an output filename; hence the my_gebco.cpt in the example.
.SH "SEE ALSO"
.IR GMT (l),
.IR grd2cpt (l)
