-------------------------------------------------------------------------------
--
--  Filename        : $Source: /cvsroot/gnade/gnade/tools/odbc.ads,v $
--  Description     : Query Module based upon ODBC                           --
--  Author          : Michael Erdmann <michael.erdmann@snafu.de>             --
--  Created         : 8.8.2001                                               --
--  Last Modified By: $Author: merdmann $
--  Last Modified On: $Date: 2003/05/10 16:24:03 $
--  Status          : $State: Exp $
--
--  Copyright (C) 2000 Michael Erdmann                                       --
--                                                                           --
--  GNADE is free software;  you can redistribute it  and/or modify it under --
--  terms of the  GNU General Public License as published  by the Free Soft- --
--  ware  Foundation;  either version 2,  or (at your option) any later ver- --
--  sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
--  OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
--  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
--  for  more details.  You should have  received  a copy of the GNU General --
--  Public License  distributed with GNAT;  see file COPYING.  If not, write --
--  to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
--  MA 02111-1307, USA.                                                      --
--                                                                           --
--  As a special exception,  if other files  instantiate  generics from this --
--  unit, or you link  this unit with other files  to produce an executable, --
--  this  unit  does not  by itself cause  the resulting  executable  to  be --
--  covered  by the  GNU  General  Public  License.  This exception does not --
--  however invalidate  any other reasons why  the executable file  might be --
--  covered by the  GNU Public License.                                      --
--                                                                           --
--  GNADE is implemented to work with GNAT, the GNU Ada compiler.            --
--                                                                           --
--  Functional Description                                                   --
--  ======================                                                   --
--                                                                           --
--  In contains the following sections:                                      --
--                                                                           --
--  Section 1. General support procedures                                    --
--  Section 2. Connection Management                                         --
--  Section 3. Query Management                                              --
--                                                                           --
--  Restrictions                                                             --
--  ============                                                             --
--  None                                                                     --
--                                                                           --
--  References                                                               --
--  ==========                                                               --
--  None                                                                     --
--                                                                           --
-------------------------------------------------------------------------------
--* Ada
with Ada.Strings.Unbounded;    use Ada.Strings.Unbounded;
with Tools;                    use Tools;

package ODBC is

   ------------
   -- Object --
   ------------

   type Object is private;

   -------------------
   -- Result_Record --
   -------------------
   subtype Result_Record is String_Array_Access;

   Null_Result_Record : constant Result_Record := null;

   ------------------------
   -- Source_Information --
   ------------------------
   type Source_Information is record
         Server      : Unbounded_String := Null_Unbounded_String;
         Description : Unbounded_String := Null_Unbounded_String;
      end record;

   Null_Source_Information : constant Source_Information :=
                           ( Null_Unbounded_String, Null_Unbounded_String );

   ----------------
   -- Initialize --
   ----------------
   procedure Initialize(
      This : in out Object );

   procedure Finalize(
      This : in out Object );

   procedure Authorization(
      This     : in out Object;
      Login    : in String;
      Password : in String );

   procedure Data_Source(
      This     : in out Object;
      Name     : in String );	    

   function Data_Source(
      This  : in Object;
      First : in Boolean := False ) return Source_Information;

   procedure Connect(
      This     : in out Object;
      Source   : in String := "" );

   procedure Disconnect(
      This     : in out Object );

   procedure Query(
      This         : in out Object;
      Query_String : in String );

   function Field_Name(
      This         : in Object;
      Pos          : in Positive ) return String;

   function Fetch(
      This : in Object ) return Result_Record;

   function Columns(
      This : in Object ) return Integer;

   function Affected_Rows(
      This : in Object ) return Integer;

   function To_String(
      Result : in Result_Record;
      Pos    : in Integer ) return String;

   procedure Free( S : in out String_Array_Access );


   function Tables(
      This         : in Object;
      Catalog_Name : in String;
      Schema_Name  : in String ) return String_Array_Access;

   function Procedures(
      This         : in Object;
      Catalog_Name : in String;
      Schema_Name  : in String ) return String_Array_Access;

   procedure Get_Error(
      This     : in out Object;
      Error    : out Unbounded_String;
      Message  : out Unbounded_String );

private
   type Object_Data;
   type Object_Data_Access is access Object_Data;

   type Object is record
         Data : Object_Data_Access := null;
      end record;

end ODBC;
