#"
# Copyright (C) 2005, 2006, 2007 Free Software Foundation, Inc.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

#!/bin/sh -x


if [ -z "$3" ]; then
	echo "Usage: `basename %0` <gnash_builddir> <gnash_srcdir> <swfdec_tracedir>" >&2
	exit 1
fi

BUILDDIR="$1"
SRCDIR="$2"
SWFDECTRACEDIR="$3"
NOW=`date`

GPROCESSOR="${BUILDDIR}/utilities/gprocessor"
SWFDEC_GNASH_TESTER="${SRCDIR}/swfdec_gnash_tester"

OUTPUTSCRIPT="${BUILDDIR}/testsuite/swfdec/run_swfdec_testsuite"

cat<<EOF > "${OUTPUTSCRIPT}"
#!/bin/sh

# Generated by gen_run_swfdec_testsuite.sh on
# $NOW

export GPROCESSOR=${GPROCESSOR}
EXPECTPASS=${SRCDIR}/PASSING

for test in \`ls ${SWFDECTRACEDIR}/*.swf\`; do
	testname=\`basename \${test}\`
	expectpass=no
	if grep -q "^\${testname}\$" \${EXPECTPASS}; then
		expectpass="yes"
	fi
	echo "NOTE: running \${testname} (expect pass: \${expectpass})"
	if ${SWFDEC_GNASH_TESTER} \${test} > \${testname}.log; then
		if [ "\${expectpass}" = "yes" ]; then
			echo "PASSED: \${test}"
		else
			echo "XPASSED: \${test}"
		fi	
	else
		if [ "\${expectpass}" = "yes" ]; then
			echo "FAILED: \${testname} (traces in \${testname}.trace-gnash, log in \${testname}.log)"
		else
			echo "XFAILED: \${testname} (traces in \${testname}.trace-gnash, log in \${testname}.log)"
		fi
	fi
done

EOF

