with Glib;              use Glib;
with Gdk;               use Gdk;
with Gdk.Drawable;      use Gdk.Drawable;
with Gdk.GC;            use Gdk.GC;
with Gtkada.Canvas;     use Gtkada.Canvas;
with Gtk.Widget;        use Gtk.Widget;
with Gdk.Color;         use Gdk.Color;
with Pango.Font;        use Pango.Font;
with Pango.Layout;      use Pango.Layout;
with Gtk.Extra.PsFont;  use Gtk.Extra.PsFont;

with Ada.Text_IO;      use Ada.Text_IO;

package body Test_Display_Items is

   White_GC : Gdk.GC.Gdk_GC;
   Grey_GC  : Gdk.GC.Gdk_GC;
   Black_GC : Gdk.GC.Gdk_GC;
   Font     : Pango_Font_Description;

   Font_Size : constant Gint := 8;
   Text : constant String := "1: My_Variable";

   -------------
   -- Gtk_New --
   -------------

   procedure Gtk_New
     (Item : out Display_Item;
      Widget : access Gtk_Widget_Record'Class;
      Win  : in Gdk.Window.Gdk_Window) is
   begin
      Item := new Display_Item_Record;
      Test_Display_Items.Initialize (Item, Widget, Win);
   end Gtk_New;

   ----------------
   -- Initialize --
   ----------------

   procedure Initialize
     (Item : access Display_Item_Record'Class;
      Widget : access Gtk_Widget_Record'Class;
      Win  : in Gdk.Window.Gdk_Window)
   is
      use type Gdk.GC.Gdk_GC;
      Alloc_Width  : Gint;
      Alloc_Height : Gint;
      Grey  : Gdk_Color;
   begin
      if White_GC = null then
         Gdk_New (White_GC, Win);
         Set_Foreground (White_GC, White (Get_Default_Colormap));

         Grey := Parse ("grey");
         Alloc (Gtk.Widget.Get_Default_Colormap, Grey);

         Gdk_New (Grey_GC, Win);
         Set_Foreground (Grey_GC, Grey);

         Gdk_New (Black_GC, Win);
         Set_Foreground (Black_GC, Black (Gtk.Widget.Get_Default_Colormap));

         Font := From_String ("Helvetica bold" & Font_Size'Img);
      end if;

      Item.Layout := Create_Pango_Layout (Widget, Text);
      Set_Font_Description (Item.Layout, Font);

      Get_Pixel_Size (Item.Layout, Alloc_Width, Alloc_Height);
      Set_Screen_Size (Item, Alloc_Width + 8, Alloc_Height + 4);
   end Initialize;

   ----------
   -- Draw --
   ----------

   procedure Draw (Item : access Display_Item_Record;
                   Canvas : access Interactive_Canvas_Record'Class;
                   Dest : Gdk.Pixmap.Gdk_Pixmap;
                   Xdest, Ydest : Glib.Gint)
   is
      Alloc_Width  : Gint := Gint (Get_Coord (Item).Width);
      Alloc_Height : Gint := Gint (Get_Coord (Item).Height);
   begin
      Draw_Rectangle (Dest,
                      GC     => White_GC,
                      Filled => True,
                      X      => Xdest,
                      Y      => Ydest + Font_Size,
                      Width  => Alloc_Width - 1,
                      Height => Alloc_Height - Font_Size - 1);

      Draw_Rectangle (Dest,
                      GC     => Grey_GC,
                      Filled => True,
                      X      => Xdest,
                      Y      => Ydest,
                      Width  => Alloc_Width - 1,
                      Height => Font_Size);

      Draw_Rectangle (Dest,
                      GC     => Black_GC,
                      Filled => False,
                      X      => Xdest,
                      Y      => Ydest,
                      Width  => Alloc_Width - 1,
                      Height => Alloc_Height - 1);

      Draw_Line (Dest,
                 GC     => Black_GC,
                 X1     => Xdest,
                 Y1     => Ydest + Font_Size,
                 X2     => Xdest + Alloc_Width - 1,
                 Y2     => Ydest + Font_Size);

      Draw_Layout (Dest, Black_GC, Xdest + 4, Ydest + 2, Item.Layout);
   end Draw;

   ---------------------
   -- On_Button_Click --
   ---------------------

   procedure On_Button_Click (Item   : access Display_Item_Record;
                              Button : Glib.Guint;
                              X, Y   : Glib.Gint)
   is
   begin
      Put_Line ("Was clicked on");
   end On_Button_Click;

end Test_Display_Items;

