/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
 #ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

 //#include <unistd.h> //for Linux sleep(); replaced 20051126 with g_usleep () code
#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h> //needed for keyboard translations


#include "callbacks.h"
#include "interface.h"
#include "support.h"
#include "BinauralBeat.h"
#include "gnaural.h"
#include "ScheduleGUI.h"

extern GtkWindow *window1;

gboolean bbl_KeyboardUndoState=TRUE; //needed for keyboard undo operations


//======================
//////////////////////
//These were NOT inserted by Glade:
void bbl_ScheduleGUI_redraw(gboolean rescaleflag)
{//draws the graph:
 GtkWidget * widget= lookup_widget (GTK_WIDGET (window1), "drawingarea1");
 if (rescaleflag==TRUE) ScheduleGUI_ConvertDurHzToXY(widget);
	ScheduleGUI_DrawGraph(widget);
}

//////////////////////
void bbl_BackupDataPoints()
{
  ScheduleGUI_BackupDataPoints();
 GtkWidget * menuitem= lookup_widget (GTK_WIDGET (window1), "undo1");
 gtk_widget_set_sensitive ((GtkWidget *)menuitem, true);
}


//////////////////////
void bbl_ScheduleGUI_reinit()
{
  ScheduleGUI_SetupDataPoints();
  ScheduleGUI_ProgressIndicatorFlag=TRUE;
  bbl_ScheduleGUI_redraw(TRUE);
}



//////////////////////
//turns ScheduleGUI data in to a BinauralBeat Schedule
void bbl_ScheduleGUI_ApplyToBBSchedule()
{
 ScheduleGUI_ProgressIndicatorFlag=TRUE;
	DataPoint * currentDataPoint=ScheduleGUI_FirstDataPoint;	
 int current_time=bb->TotalSampleCount;

	//count size of list:
 int count=1;
	while (currentDataPoint->NextDataPoint!=NULL)
	{
  ++count;
			currentDataPoint=currentDataPoint->NextDataPoint;
	}

 bb->ScheduleEntriesCount = count;
 if (bb->Schedule != NULL) delete [] bb->Schedule;
 bb->Schedule = new CItinerary[bb->ScheduleEntriesCount];
 //20060331: tried bb->ScheduleEntriesCount = 0 to ensure in-bounds; crashed gnaural
 bb->ScheduleTime = 0;

 //now load key variables in to Schedule vars:
 currentDataPoint=ScheduleGUI_FirstDataPoint;	
 count=0;
	do 
	{
  bb->Schedule[count].FreqLStart  = (float) (currentDataPoint->hz*.5);
  bb->Schedule[count].FreqRStart  = (float) (currentDataPoint->hz*-.5);
  bb->Schedule[count].Duration     = (float) (currentDataPoint->duration);
  bb->ScheduleTime += (currentDataPoint->duration);
  bb->Schedule[count].AbsoluteEndTime_100 =	(unsigned int) (bb->ScheduleTime *100);
		currentDataPoint=currentDataPoint->NextDataPoint;
  ++count;
} while (currentDataPoint!=NULL);

 //now figure Schedule's FreqEnds and Spreads:
 currentDataPoint=ScheduleGUI_FirstDataPoint;	
 count=0;
 int previnlist, nextinlist;
	do 
	{
if ((nextinlist = count + 1) >= bb->ScheduleEntriesCount)	 nextinlist = 0;
bb->Schedule[count].FreqLEnd = bb->Schedule[nextinlist].FreqLStart;
bb->Schedule[count].FreqREnd = bb->Schedule[nextinlist].FreqRStart;
bb->Schedule[count].FreqLSpread = 	bb->Schedule[count].FreqLEnd - bb->Schedule[count].FreqLStart;
bb->Schedule[count].FreqRSpread = 	bb->Schedule[count].FreqREnd - bb->Schedule[count].FreqRStart;
if ((previnlist = count - 1) < 0) 	bb->Schedule[count].PrevAbsoluteEndTime_100 = 0;
else 	bb->Schedule[count].PrevAbsoluteEndTime_100 =	  bb->Schedule[previnlist].AbsoluteEndTime_100;
currentDataPoint=currentDataPoint->NextDataPoint;
++count;
}while (currentDataPoint!=NULL);
}


//////////////////////
//rounds to "roundingval":  1=1th, 10=10th, 100=100th
//eventually should separate duration and hz processing
void bbl_ScheduleGUI_RoundValues(double roundingval, gboolean duration=TRUE, gboolean hz=TRUE)
{
 if (ScheduleGUI_FirstDataPoint==NULL || roundingval <=0) return;
	DataPoint * currentDataPoint=ScheduleGUI_FirstDataPoint;	
 int val;
	do {
  if (hz==TRUE && currentDataPoint->state==SCHEDULEGUI_SELECTED) {
  val=(int)(currentDataPoint->hz*roundingval+.5);
  currentDataPoint->hz=(double)(val/roundingval);
   if (currentDataPoint->hz < 0) currentDataPoint->hz = 0;
  }

  if (duration==TRUE && currentDataPoint->state==SCHEDULEGUI_SELECTED) {
  val=(int)(currentDataPoint->duration*roundingval+.5);
  currentDataPoint->duration=(double)(val/roundingval);
   if (currentDataPoint->duration < 0) currentDataPoint->duration = 0;
  }
  currentDataPoint=currentDataPoint->NextDataPoint;
 }while (currentDataPoint!=NULL);
 bbl_ScheduleGUI_redraw(TRUE); 
}


//////////////////////
//This was created to offer an easy means to set/alter the overall 
//objective of a schedule; probably obsolete now, with mouse-selecting.
//If a schedule value is over (belowflag==0)
//or under (belowflag!=0) threshold, it will be set to the newvalue.
//If sumflag !=0, newvalue is added to each entry.
void bbl_ScheduleGUI_OverallThresholdSetHz(double newvalue, gboolean sumflag, double threshold, gboolean belowflag)
{
 if (ScheduleGUI_FirstDataPoint==NULL) return;
 
	DataPoint * currentDataPoint=ScheduleGUI_FirstDataPoint;	
 int val;
	do {
  if (belowflag==FALSE) 
   { 
    if (currentDataPoint->hz > threshold)
     {
      if (sumflag==0)  { currentDataPoint->hz=newvalue; }
      else { currentDataPoint->hz+=newvalue; }

      if (currentDataPoint->hz<0) currentDataPoint->hz=0.0;
     }
    }
  else 
   { 
    if (currentDataPoint->hz<threshold) 
     {
      if (sumflag==0)  { currentDataPoint->hz=newvalue; }
      else { currentDataPoint->hz+=newvalue; }

      if (currentDataPoint->hz<0) currentDataPoint->hz=0.0;
     }
    }

  currentDataPoint=currentDataPoint->NextDataPoint;
 }while (currentDataPoint!=NULL);
 bbl_ScheduleGUI_redraw(TRUE); 
}





//end of NOT inserted by Glade functions
//======================




//====================================================
//start of Glade created callbacks:
//====================================================
//==========================
//This function kills app if user clicks the app's window-manger Close button (upper-right x-box)
//Return TRUE to tell not to send the "destroy" signal (keep the app running).
//Returning FALSE will ask that "destroy" be emitted, which 
//in turn calls my "destroy" signal handler.
gboolean on_window1_delete_event (GtkWidget * widget,
			 GdkEvent * event, gpointer user_data)
{
  return FALSE; //returning FALSE will cause GTK to send destroy signal (calling my on_window1_destroy())
}


//==========================
void on_window1_destroy                     (GtkObject       *object,
                                        gpointer         user_data)
{
  ScheduleGUI_Cleanup();
  gtk_main_quit ();
}





//========================================
void on_save1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
 //statusbar would be good for this sort of message, but I haven't really implemented
 //when to clear it, nor have really standardized what goes there vs. what goes to the 
 //ProgramStatus window. Latter is more popular, so it refreshes in more timely fashion
// bbl_UpdateGUI_Statusbar("Saved current settings to:",szFile_gnaural_schedule_txt);
 bbl_UpdateGUI_ProgramStatus("Saved current settings to:",szFile_gnaural_schedule_txt);
  bb->WriteScheduleToFile ();
}


//========================================
void on_save_as1_activate(GtkMenuItem     *menuitem, gpointer  user_data)
{
 GtkWidget *dialog;

dialog = gtk_file_chooser_dialog_new ("Save Gnaural Schedule as...",
				     GTK_WINDOW(window1),
				      GTK_FILE_CHOOSER_ACTION_SAVE,
				      GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
				      GTK_STOCK_SAVE, GTK_RESPONSE_ACCEPT,
				      NULL);
//gtk_entry_set_text (GTK_ENTRY (entry_Input), "Gnaural.wav");
 gtk_file_chooser_set_current_folder (GTK_FILE_CHOOSER (dialog), szDir_Gnaural);
 gtk_file_chooser_set_current_name(GTK_FILE_CHOOSER(dialog),"gnaural_schedule.txt");
 
 //gtk_file_chooser_set_do_overwrite_confirmation (GTK_FILE_CHOOSER (dialog), TRUE);//doesn't exist yet in Debian unstable
 
if (gtk_dialog_run (GTK_DIALOG (dialog)) == GTK_RESPONSE_ACCEPT)
  {
   char * filename=gtk_file_chooser_get_filename (GTK_FILE_CHOOSER (dialog));
	  if (strlen(filename)>0)	 
   {
    bbl_UpdateGUI_ProgramStatus("Saved current settings to:",filename);
    bb->WriteScheduleToFile (filename);
   }
  g_free (filename);
  }  
  
  
 gtk_widget_destroy (dialog);
}



//========================================
void on_open1_activate(GtkMenuItem     *menuitem, gpointer         user_data)
{
 GtkWidget *dialog;

dialog = gtk_file_chooser_dialog_new ("Open File",
				      GTK_WINDOW(window1),
				      GTK_FILE_CHOOSER_ACTION_OPEN,
				      GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
				      GTK_STOCK_OPEN, GTK_RESPONSE_ACCEPT,
				      NULL);

 gtk_file_chooser_set_current_folder (GTK_FILE_CHOOSER (dialog), szDir_Gnaural);
 
GtkFileFilter *filter;
filter = gtk_file_filter_new ();
gtk_file_filter_add_pattern (filter, "*.txt"); 
gtk_file_filter_set_name (filter,"*.txt");
gtk_file_chooser_add_filter (GTK_FILE_CHOOSER (dialog), filter); 
filter = gtk_file_filter_new ();
gtk_file_filter_add_pattern (filter, "*"); 
gtk_file_filter_set_name (filter,"All Files");
gtk_file_chooser_add_filter (GTK_FILE_CHOOSER (dialog), filter); 
 
 
if (gtk_dialog_run (GTK_DIALOG (dialog)) == GTK_RESPONSE_ACCEPT)
  {
    char *filename;

    filename = gtk_file_chooser_get_filename (GTK_FILE_CHOOSER (dialog));
 strcpy(szFile_gnaural_schedule_txt, filename);
    g_free (filename);
   //Tell BB that we've changed filename:
   bb->SchedFilename=szFile_gnaural_schedule_txt;
//   bbl_UpdateGUI_Filename();
   //Use old OnReload to put new filename in action:
   bbl_OnReloadFile();
  bbl_ScheduleGUI_reinit();   
  }

gtk_widget_destroy (dialog);
 
}


//========================================
void on_edit1_activate (GtkMenuItem * menuitem, gpointer user_data)
{	//this is a hack -- no time to write editor or figure out how to access default editor, so let a typical platform editors do it:
  //###############FOR LINUX################
    #ifndef GNAURAL_WIN32
 //NOTE: I think it is trying to launch this twice, maybe a mouse-click artifact? Might want to try be sure i can only run once
 //BUG 20060116: if user leaves Gedit open after exiting, it is as if the sound system is still being owned by Gnaual until Gedit is closed
 sprintf(szPath_Temp,"%s%s%s","gedit ",szFile_gnaural_schedule_txt," &");
  system (szPath_Temp);
    #endif     
 
  //###############FOR WIN32################
    #ifdef GNAURAL_WIN32
  ShellExecute(0,
"open", // Operation to perform
//"c:\\windows\\notepad.exe", // Application name
"notepad.exe", // Application name
szFile_gnaural_schedule_txt, // Additional parameters
0, // Default directory
SW_SHOW);  
    #endif      
}


//========================================
void on_reload1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
 if (gnaural_writefilename!=NULL) return;//disable if we're doing an audio file write.
  //first backup data:
 bbl_BackupDataPoints();
 
 
  bbl_OnReloadFile ();
  bbl_ScheduleGUI_reinit();
// bbl_UpdateGUI_Filename();
}


//========================================
void  on_restore_default_settings_and_file1_activate
  (GtkMenuItem * menuitem, gpointer user_data)
{
 if (gnaural_writefilename!=NULL) return;//disable if we're doing an audio file write.
  bbl_OnRestoreDefaultFile ();
  bbl_ScheduleGUI_reinit();
}









//========================================
void on_create_mp3_audio_file1_activate     (GtkMenuItem     *menuitem,     gpointer      user_data)
{
 //This is experimental, requires LAME, and runs a second instance of Gnaural in the background;
 //Sorry, Windows users - I don't have a way to hack this for you yet :-(

 #ifdef GNAURAL_WIN32
      bbl_MessageDialogBox ("Currently, the Windows version can only do this at the command line. Be sure LAME is installed\n(see http://lame.sourceforge.net/),\nthen type:\n\n\tgnaural -o | lame - MyMeditation.mp3",GTK_MESSAGE_INFO, GTK_BUTTONS_OK);
     return;
   #endif     


 
 if (bb->loops<1) {
  if (false==bbl_MessageDialogBox ("You are in infinite-loop mode. Do you really want to fill all the space on your hard drive?",GTK_MESSAGE_WARNING, GTK_BUTTONS_YES_NO))
  {
  return;//don't start write an infinitely large file
  }
 }

 //TODO: check automatically for LAME
 if (false==bbl_MessageDialogBox ("Do you have LAME installed? If not, this step will fail.\nSee http://lame.sourceforge.net/",GTK_MESSAGE_WARNING, GTK_BUTTONS_YES_NO))
 {
  return;
 }
 //TODO check disk space for user, update GUI status window to tell that writing is going on
 
 //Ask for a name for the MP3 file:
 GtkWidget *dialog;

dialog = gtk_file_chooser_dialog_new ("Save MP3 Audio File",
				     GTK_WINDOW(window1),
				      GTK_FILE_CHOOSER_ACTION_SAVE,
				      GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
				      GTK_STOCK_SAVE, GTK_RESPONSE_ACCEPT,
				      NULL);
//gtk_entry_set_text (GTK_ENTRY (entry_Input), "Gnaural.wav");
 gtk_file_chooser_set_current_folder(GTK_FILE_CHOOSER(dialog),szDir_CurrentWorking);
 gtk_file_chooser_set_current_name(GTK_FILE_CHOOSER(dialog),"Gnaural.mp3");
 
 //gtk_file_chooser_set_do_overwrite_confirmation (GTK_FILE_CHOOSER (dialog), TRUE);//doesn't exist yet in Debian unstable
 

if (gtk_dialog_run (GTK_DIALOG (dialog)) == GTK_RESPONSE_ACCEPT)
  {
   char * filename=gtk_file_chooser_get_filename (GTK_FILE_CHOOSER (dialog));
	if (strlen(filename)>0)	 
 {
  //this works great, just doesn't give user any way to know when it is done, and (worse) doesn't always reliably find it's own executable.
  //###############FOR LINUX################
  #ifndef GNAURAL_WIN32
    sprintf(szPath_Temp,"%s -o | lame - %s &",szFile_ExecutablePath, filename);  
    system(szPath_Temp);
  #endif
  //###############FOR WIN32################
  #ifdef GNAURAL_WIN32
    sprintf(szPath_Temp,"%s -o | lame - %s",szFile_ExecutablePath, filename);  
  system(szPath_Temp);
//  _spawn(szPath_Temp);  
//_spawnlp (_P_DETACH, szFile_ExecutablePath, "-o", "|", "lame","-",  filename, NULL);
//_execlp (szFile_ExecutablePath, "-o", "|", "lame","-",  filename, NULL);
/*
  ShellExecute(0,
"open", // Operation to perform
szPath_Temp, // Application name
NULL, // Additional parameters
0, // Default directory
SW_SHOW);  
*/
  #endif
  
    bbl_MessageDialogBox("A second copy of Gnaural has be spawned, and will run in the background until finished. In case of a problem, you can kill the processes with:\nkillall gnaural",GTK_MESSAGE_INFO);
  }
   g_free (filename);
 }
gtk_widget_destroy (dialog);

}







//========================================
void on_create_wav_audio_file1_activate (GtkMenuItem * menuitem,  gpointer user_data)
{
 if (bb->loops<1) {
  if (false==bbl_MessageDialogBox ("You are in infinite-loop mode. Do you really want to fill all the space on your hard drive?",GTK_MESSAGE_WARNING, GTK_BUTTONS_YES_NO))
  {
  return;//can't write an infinitely large file! (COULD USE A DIALOG)
  }
 }
 if  (gnaural_writefilename!=NULL) {
  bbl_MessageDialogBox ("you are already writing one file. Sorry.");
  return; //this means someone is already writing (COULD USE A DIALOG)
 }
//TODO check disk space for user, update GUI status window to tell that writing is going on
 GtkWidget *dialog;

dialog = gtk_file_chooser_dialog_new ("Save WAV Audio File",
				     GTK_WINDOW(window1),
				      GTK_FILE_CHOOSER_ACTION_SAVE,
				      GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
				      GTK_STOCK_SAVE, GTK_RESPONSE_ACCEPT,
				      NULL);
//gtk_entry_set_text (GTK_ENTRY (entry_Input), "Gnaural.wav");
 gtk_file_chooser_set_current_name(GTK_FILE_CHOOSER(dialog),"Gnaural.wav");
 
 //gtk_file_chooser_set_do_overwrite_confirmation (GTK_FILE_CHOOSER (dialog), TRUE);//doesn't exist yet in Debian unstable

 if (gtk_dialog_run (GTK_DIALOG (dialog)) == GTK_RESPONSE_ACCEPT)
  {
   char * filename=gtk_file_chooser_get_filename (GTK_FILE_CHOOSER (dialog));
	if (strlen(filename)>0)	 
 {
  bbl_OnButton_Stop ();
  bbl_do_writethreadWAV (filename);
  int tmpcnt=0;
  while (gnaural_writefilename==NULL && ++tmpcnt<5) {//give some time for thread to get what it needs before freeing below
   g_usleep (1000);
  }
 }
   g_free (filename);
  }
  
gtk_widget_destroy (dialog);
}


//========================================
void
on_quit1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
    gtk_widget_destroy( (GtkWidget *)window1 );
  //  gtk_main_quit ();
}


//========================================
void on_set_base_frequency1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
 if (gnaural_writefilename!=NULL) return;//disable if we're doing an audio file write.
  GtkWidget *dialog = gtk_dialog_new_with_buttons ("Your Dream Base",
						   window1,
						   (GtkDialogFlags)
						   (GTK_DIALOG_MODAL |
						    GTK_DIALOG_DESTROY_WITH_PARENT),
						   GTK_STOCK_OK,
						   GTK_RESPONSE_ACCEPT,
						   GTK_STOCK_CANCEL,
						   GTK_RESPONSE_REJECT,
						   NULL);

//add some stuff:
  GtkWidget *label = gtk_label_new ("Set the new base frequency");
  GtkWidget *entry_Input = gtk_entry_new ();
  char tmpstring[64];
  sprintf (tmpstring, "%g", bb->FreqBase);
  gtk_entry_set_text (GTK_ENTRY (entry_Input), tmpstring);

  // Add the label, and show everything we've added to the dialog. 
  gtk_container_add (GTK_CONTAINER (GTK_DIALOG (dialog)->vbox), label);
  gtk_container_add (GTK_CONTAINER (GTK_DIALOG (dialog)->vbox), entry_Input);
  gtk_widget_show_all (dialog);

  //block until I get a response:
  gint result = gtk_dialog_run (GTK_DIALOG (dialog));
  switch (result)
    {
    case GTK_RESPONSE_ACCEPT:
      {
//       putc('\a',stderr);
	double tmpd;
	tmpd = atof (gtk_entry_get_text (GTK_ENTRY (entry_Input)));
	if (tmpd < 0 || tmpd > 60000)
	  break;


	if (FALSE == gnaural_ManualFreqBaseControl)	//have to put it in manual control:
	  {
	    gnaural_ManualFreqBaseControl = TRUE;
	    gnaural_FreqBase_old = bb->FreqBase;
	    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (lookup_widget(GTK_WIDGET (window1), "checkbutton_FreqBase")), TRUE);
	  }
	bb->FreqBase = tmpd;
	bbl_UpdateGUI_ManualControlInfo ();
	bbl_UpdateGUI_UserDataInfo ();
      }
      break;
    default:
      break;
    }
  gtk_widget_destroy (dialog);
}


void on_stereo_noise1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
 if (gnaural_writefilename!=NULL) return;//disable if we're doing an audio file write.
  bb->StereoNoiz =
    gtk_check_menu_item_get_active (GTK_CHECK_MENU_ITEM (menuitem)) ==
    true ? true : false;
}


void on_infinite_loop_mode1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
 if (gnaural_writefilename!=NULL) return;//disable if we're doing an audio file write.
  if (gtk_check_menu_item_get_active (GTK_CHECK_MENU_ITEM (menuitem)) == true)
    bb->loops = bb->loopcount = 0;
  else
    bb->loops = bb->loopcount = 1;
  bbl_UpdateGUI_LoopModeInfo ();
  bbl_UpdateGUI_Info ();
}


void on_disable_screensaver1_activate (GtkMenuItem * menuitem, gpointer user_data)
{				//cruel hacky way:
// system("killall xscreensaver");
//  if (gtk_check_menu_item_get_active (GTK_CHECK_MENU_ITEM (menuitem)) == false) system("xscreensaver &")
  //nicer way:
  if (gtk_check_menu_item_get_active (GTK_CHECK_MENU_ITEM (menuitem)) == true)
    system ("xset s off");
  else
    system ("xset s on");
}


void on_gnaural_help1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
 bbl_MessageDialogBox(szGnauralHelp, GTK_MESSAGE_INFO);
}


void on_about_gnaural1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
  bbl_AboutDialogBox ();
// char info[256];
//   sprintf(info, "Gnaural\nby Bret Logan (c) 2005\nhttp://gnaural.sourceforge.net/\nVer. %s", VERSION);
//bbl_DialogBox(info, "About Gnaural");
}


void on_buttonPlay_clicked (GtkButton * button, gpointer user_data)
{
  bbl_OnButton_Play ();
}


void on_buttonRewind_clicked (GtkButton * button, gpointer user_data)
{
 if (gnaural_writefilename!=NULL) return;//disable if we're doing an audio file write.
  bb->previous ();
  if (gnaural_pauseflag == 0)
    bb->previous ();		//do it again!
  bb->InfoFlag |= BB_NEWENTRY;
}


void on_buttonForward_clicked (GtkButton * button, gpointer user_data)
{
 if (gnaural_writefilename!=NULL) return;//disable if we're doing an audio file write.
  bb->next ();
  bb->InfoFlag |= BB_NEWENTRY;
}


void on_buttonStop_clicked (GtkButton * button, gpointer user_data)
{
  bbl_OnButton_Stop ();
}


void on_vscale_VolumeTone_value_changed (GtkRange * range, gpointer user_data)
{
 if (gnaural_writefilename!=NULL) return;//disable if we're doing an audio file write.
  // int from 0 to 16384:
  bb->Volume_Tone = (int) (163.84 * gtk_range_get_value (range));
}


void on_vscale_VolumeNoise_value_changed (GtkRange * range, gpointer user_data)
{
 if (gnaural_writefilename!=NULL) return;//disable if we're doing an audio file write.
  bb->Volume_Noiz = (0.01 * gtk_range_get_value (range));
}


void on_hscale_FreqBeat_value_changed (GtkRange * range, gpointer user_data)
{
 if (gnaural_writefilename!=NULL) return;//disable if we're doing an audio file write.
  if (bb->ManualFreqOffsetControl == TRUE)
    {
      bb->ManualFreqLOffset = (gtk_range_get_value (range) * 0.5);
      bb->ManualFreqROffset = -(bb->ManualFreqLOffset);
    }
}


void on_checkbutton_FreqBeat_toggled (GtkToggleButton * togglebutton,
				 gpointer user_data)
{
  bb->ManualFreqOffsetControl = gtk_toggle_button_get_active (togglebutton);
  on_hscale_FreqBeat_value_changed (GTK_RANGE (lookup_widget (GTK_WIDGET (window1), "hscale_FreqBeat")), NULL);
}


void on_hscale_FreqBase_value_changed (GtkRange * range, gpointer user_data)
{
 if (gnaural_writefilename!=NULL) return;//disable if we're doing an audio file write.
  if (gnaural_ManualFreqBaseControl == TRUE)
    bb->FreqBase = gtk_range_get_value (range);
  bbl_UpdateGUI_ManualControlInfo ();
}

void on_checkbutton_FreqBase_toggled (GtkToggleButton * togglebutton,
				 gpointer user_data)
{
  if (TRUE ==
      (gnaural_ManualFreqBaseControl = gtk_toggle_button_get_active (togglebutton)))
    {
      gnaural_FreqBase_old = bb->FreqBase;
      bb->FreqBase =
	gtk_range_get_value (GTK_RANGE (lookup_widget(GTK_WIDGET (window1), "hscale_FreqBase")));
    }
  else
    {
      bb->FreqBase = gnaural_FreqBase_old;
    }
  bbl_UpdateGUI_ManualControlInfo ();
}








//==========================
void on_set_beat_frequency1_activate (GtkMenuItem * menuitem, gpointer user_data)
{
 if (gnaural_writefilename!=NULL) return;//disable if we're doing an audio file write.
  GtkWidget *dialog = gtk_dialog_new_with_buttons ("Set Your Beat",
						   window1,
						   (GtkDialogFlags)
						   (GTK_DIALOG_MODAL |
						    GTK_DIALOG_DESTROY_WITH_PARENT),
						   GTK_STOCK_OK,
						   GTK_RESPONSE_ACCEPT,
						   GTK_STOCK_CANCEL,
						   GTK_RESPONSE_REJECT,
						   NULL);

//add some stuff:
  GtkWidget *label = gtk_label_new ("Set a fixed beat frequency");
  GtkWidget *entry_Input = gtk_entry_new ();
  char tmpstring[64];
  sprintf (tmpstring, "%g", bb->ManualFreqLOffset*2);
  gtk_entry_set_text (GTK_ENTRY (entry_Input), tmpstring);

  // Add the label, and show everything we've added to the dialog. 
  gtk_container_add (GTK_CONTAINER (GTK_DIALOG (dialog)->vbox), label);
  gtk_container_add (GTK_CONTAINER (GTK_DIALOG (dialog)->vbox), entry_Input);
  gtk_widget_show_all (dialog);

  //block until I get a response:
  gint result = gtk_dialog_run (GTK_DIALOG (dialog));
  switch (result)
    {
    case GTK_RESPONSE_ACCEPT:
      {
	double tmpd;
	tmpd = 0.5 * atof (gtk_entry_get_text (GTK_ENTRY (entry_Input)));
	if (tmpd < 0 || tmpd > 1000)
	  break;

	if (FALSE == bb->ManualFreqOffsetControl)
	  {
	    bb->ManualFreqOffsetControl = TRUE;
	    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (lookup_widget(GTK_WIDGET (window1),"checkbutton_FreqBeat")), TRUE);
	  }
	  bb->ManualFreqLOffset = tmpd;
	  bb->ManualFreqROffset = -tmpd;
  	bbl_UpdateGUI_ManualControlInfo ();
  	bbl_UpdateGUI_UserDataInfo ();
      }
      break;
    default:
      break;
    }
  gtk_widget_destroy (dialog);
}



//==========================
gboolean on_drawingarea1_expose_event           (GtkWidget       *widget,
                                        GdkEventExpose  *event,
                                        gpointer         user_data)
{
 return ScheduleGUI_expose_event(widget,event);
//  return FALSE;
}


//==========================
gboolean on_drawingarea1_configure_event        (GtkWidget       *widget,
                                        GdkEventConfigure *event,
                                        gpointer         user_data)
{
return ScheduleGUI_configure_event(widget,event);
//  return FALSE; //Glade put this; but mine returns TRUE
}


//==========================
//NOTE: THIS DOESN'T (APPARENTLY) ACTUALLY GET CALLED -- using on_window1_delete_event() for reliable cleanup
gboolean on_drawingarea1_delete_event           (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
 return ScheduleGUI_delete_event(widget,event,user_data);
//  return FALSE;
}


//==========================
gboolean on_drawingarea1_motion_notify_event    (GtkWidget       *widget,
                                        GdkEventMotion  *event,
                                        gpointer         user_data)
{
return ScheduleGUI_motion_notify_event(widget,event);
  //return FALSE;
}


//==========================
gboolean on_drawingarea1_button_press_event     (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
 //either backup here or in button_release_event:
 if (event->button == 1) bbl_BackupDataPoints();
 GtkWidget * menuitem= lookup_widget (GTK_WIDGET (window1), "undo1");
 gtk_widget_set_sensitive ((GtkWidget *)menuitem, true);
 menuitem=lookup_widget (GTK_WIDGET (window1), "redo1");
 gtk_widget_set_sensitive ((GtkWidget *)menuitem, false);

return ScheduleGUI_button_press_event(widget,event);
  //return FALSE;
}



//==========================
gboolean on_drawingarea1_button_release_event   (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
 //either backup here or in button_press_event:
//   bbl_BackupDataPoints();
  return ScheduleGUI_button_release_event(widget, event);
  //return FALSE;
}

//==========================
void on_graph1_apply1_activate (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  bbl_ScheduleGUI_ApplyToBBSchedule();
 //20060331: I decided that the bb->Reset isn't necessary; 
 //user doesn't want to constantly start over any time a change 
 //is made:
 // bb->Reset ();
  bbl_InitGUI ();		//to be sure sliders reflect new user data
  bbl_UpdateGUI_Info ();
  GtkLabel * widget= GTK_LABEL(lookup_widget (GTK_WIDGET (window1), "label_Filename"));
  gtk_label_set_text (widget, "Using Graph Data");
 
 //Be sure to let user still have access to previous Undo info. NOTE:
 //the implementation below is a bit inconsistent because user may
 //have been in a "Redo" state; this will now call it "Undo." Acceptable
 //for now, since user doesn't actually lose anything:
 if (ScheduleGUI_FirstBackupDataPoint!=NULL)
 {
   GtkWidget * menuitem2= lookup_widget (GTK_WIDGET (window1), "undo1");
   gtk_widget_set_sensitive ((GtkWidget *)menuitem2, true);
 }
}


//==========================
void on_graph1_clear1_activate (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
 bbl_BackupDataPoints();
 ScheduleGUI_ProgressIndicatorFlag=FALSE;
 ScheduleGUI_CleanupDataPoints(ScheduleGUI_FirstDataPoint); 
 ScheduleGUI_FirstDataPoint=NULL;
 ScheduleGUI_AddNewDataPointToEnd(1200,4);
 bbl_ScheduleGUI_redraw(TRUE);  
}



//==========================
void on_graph1_reload2_activate             (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
 //first backup data:
 bbl_BackupDataPoints();
 bbl_ScheduleGUI_reinit();
}


//==========================
void on_graph1_undo1_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
 ScheduleGUI_RestoreDataPoints(lookup_widget (GTK_WIDGET (window1), "drawingarea1"));
// bbl_ScheduleGUI_redraw(FALSE);
 //now toggle the two associated menuitems:
 gtk_widget_set_sensitive ((GtkWidget *)menuitem, false);
 GtkWidget * menuitem2=lookup_widget (GTK_WIDGET (window1), "redo1");
 gtk_widget_set_sensitive ((GtkWidget *)menuitem2, true); 
}

//==========================
void on_graph1_redo1_activate(GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
 ScheduleGUI_RestoreDataPoints(lookup_widget (GTK_WIDGET (window1), "drawingarea1"));
// bbl_ScheduleGUI_redraw(FALSE);
 //now toggle the two associated menuitems:
 gtk_widget_set_sensitive ((GtkWidget *)menuitem, false);
 GtkWidget * menuitem2=lookup_widget (GTK_WIDGET (window1), "undo1");
 gtk_widget_set_sensitive ((GtkWidget *)menuitem2, true);
}


//==========================
void on_graph_threshset_activate(GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{ 
 //first get a crude average, since 80% of the time user will just want a gross middle to work with:
 if (ScheduleGUI_FirstDataPoint==NULL) return; 
	DataPoint * currentDataPoint=ScheduleGUI_FirstDataPoint;	
 int count=0;
 double threshold=0, min=0x7fffffff, max=0;
	do {
  threshold+=currentDataPoint->hz;
  if (min>currentDataPoint->hz) min=currentDataPoint->hz;
  if (max<currentDataPoint->hz) max=currentDataPoint->hz;
  ++count;
  currentDataPoint=currentDataPoint->NextDataPoint;
 }while (currentDataPoint!=NULL);
 threshold/=count;
// threshold+=.5;
// threshold=(int)threshold;
 double newvalue=(min+max)/2;
 
  
 GtkWidget *dialog = gtk_dialog_new_with_buttons ("Threshold Set",
       NULL,
			   //(GtkWindow*) widget,
			   (GtkDialogFlags)
			   (GTK_DIALOG_MODAL |
			    GTK_DIALOG_DESTROY_WITH_PARENT),
			   GTK_STOCK_OK,
			   GTK_RESPONSE_ACCEPT,
			   GTK_STOCK_CANCEL,
			   GTK_RESPONSE_REJECT,
			   NULL);

//add some stuff:
  GtkWidget *label_thresh = gtk_label_new ("Threshold:");
  GtkWidget *entry_Input_thresh = gtk_entry_new ();
  GtkWidget *checkbutton_thresholdBelow=gtk_check_button_new_with_mnemonic (_("Affect values below threshold"));
  GtkWidget *label_newval = gtk_label_new ("\nNew Value:");
  GtkWidget *entry_Input_newval = gtk_entry_new ();
  GtkWidget *checkbutton_newvalAdd=gtk_check_button_new_with_mnemonic (_("Sum new value with values"));
  char tmpstring[64];
  sprintf (tmpstring, "%g",threshold);
  gtk_entry_set_text (GTK_ENTRY (entry_Input_thresh), tmpstring);
  sprintf (tmpstring, "%g",newvalue);
  gtk_entry_set_text (GTK_ENTRY (entry_Input_newval), tmpstring);

  // Add the label, and show everything we've added to the dialog. 
  gtk_container_add (GTK_CONTAINER (GTK_DIALOG (dialog)->vbox), label_thresh);
  gtk_container_add (GTK_CONTAINER (GTK_DIALOG (dialog)->vbox), entry_Input_thresh);
  gtk_container_add (GTK_CONTAINER (GTK_DIALOG (dialog)->vbox), checkbutton_thresholdBelow);  
  gtk_container_add (GTK_CONTAINER (GTK_DIALOG (dialog)->vbox), label_newval);
  gtk_container_add (GTK_CONTAINER (GTK_DIALOG (dialog)->vbox), entry_Input_newval);
  gtk_container_add (GTK_CONTAINER (GTK_DIALOG (dialog)->vbox), checkbutton_newvalAdd);  
  gtk_widget_show_all (dialog);

  //block until I get a response:
  gint result = gtk_dialog_run (GTK_DIALOG (dialog));
  switch (result)
    {
    case GTK_RESPONSE_ACCEPT:
      {
       threshold = atof (gtk_entry_get_text (GTK_ENTRY (entry_Input_thresh)));
       newvalue = atof (gtk_entry_get_text (GTK_ENTRY (entry_Input_newval)));
       if ( threshold < 0 )	break;
       //backup data:
       bbl_BackupDataPoints();
       ScheduleGUI_ProgressIndicatorFlag=FALSE;
       bbl_ScheduleGUI_OverallThresholdSetHz(
         newvalue,
         gtk_toggle_button_get_active ((GtkToggleButton *)checkbutton_newvalAdd),
         threshold,
         gtk_toggle_button_get_active ((GtkToggleButton *)checkbutton_thresholdBelow));
      	break;
      }
	
	default:
    break;
    }
  gtk_widget_destroy (dialog);
}

//==========================
//I am having big problems getting Glade builds to let the drawing area keep focus 
//to get keyboard input. Until I solve it, I'll just grap all keypresses caught for 
//the main window.
gboolean on_window1_key_press_event (GtkWidget       *widget,
                                        GdkEventKey     *event,
                                        gpointer         user_data)
{
//If the emission of an event signal returns TRUE, the GTK+ main loop will 
//stop propagating the current event. If it returns FALSE, the main loop will 
//propagate the event to the widget's parent. 
 if (event->state & GDK_SHIFT_MASK) {//I have to do this with Shift down because Glade/GTK steals Arrow keys:
		if (event->keyval==GDK_Up || 
       event->keyval==GDK_Down || 
       event->keyval==GDK_Left || 
       event->keyval==GDK_Right) {
   if (bbl_KeyboardUndoState == TRUE) {
    bbl_BackupDataPoints(); 
    ScheduleGUI_ProgressIndicatorFlag=FALSE;
    bbl_KeyboardUndoState = FALSE;
    }
  GtkWidget * dawidget = lookup_widget (GTK_WIDGET (window1), "drawingarea1");
   if (event->keyval==GDK_Left || event->keyval==GDK_Right) {
    ScheduleGUI_MoveSelectedDataPoints(dawidget, (event->keyval==GDK_Left) ? -1:1,0); 
    ScheduleGUI_ConvertXToDuration_AllPoints(dawidget);
   } else {
    ScheduleGUI_MoveSelectedDataPoints(dawidget, 0, (event->keyval==GDK_Up) ? -1:1); 
    ScheduleGUI_ConvertYToHz_AllPoints(dawidget);
   }
   ScheduleGUI_ConvertDurHzToXY(dawidget);// NOTE: I need to call this both to set limits and to bring XY's outside of graph back in
   ScheduleGUI_DrawGraph(dawidget);
   return TRUE;
   }
 }
 return FALSE;
 //return ScheduleGUI_key_press_event(lookup_widget (GTK_WIDGET (window1), "drawingarea1"),event);
}




//==========================
gboolean on_window1_key_release_event           (GtkWidget       *widget,
                                        GdkEventKey     *event,
                                        gpointer         user_data)
{
 
  if (event->state & GDK_SHIFT_MASK) {//I have to do this with Shift down because Glade/GTK steals Arrow keys:
		if (event->keyval==GDK_Up || 
       event->keyval==GDK_Down || 
       event->keyval==GDK_Left || 
       event->keyval==GDK_Right)   {
//        fprintf(stderr,"Got a KeyUP\n");
        bbl_KeyboardUndoState=TRUE;
       }
      }
  return FALSE;
}











//==========================
void on_graph1_roundoff_activate (GtkMenuItem *menuitem, gpointer user_data)
{
 static double roundoff = 10.0;
 GtkWidget *dialog = gtk_dialog_new_with_buttons ("Round off",
       NULL,
			   //(GtkWindow*) widget,
			   (GtkDialogFlags)
			   (GTK_DIALOG_MODAL |
			    GTK_DIALOG_DESTROY_WITH_PARENT),
			   GTK_STOCK_OK,
			   GTK_RESPONSE_ACCEPT,
			   GTK_STOCK_CANCEL,
			   GTK_RESPONSE_REJECT,
			   NULL);

//add some stuff:
  GtkWidget *label_roundingval = gtk_label_new ("Roundoff to (10=10th, 100=100th, etc.):");
  GtkWidget *entry_input_roundingval = gtk_entry_new ();
  GtkWidget *label_text = gtk_label_new ("Apply to:");
  GtkWidget *checkbutton_durations=gtk_check_button_new_with_mnemonic (_("Durations (Sec.)"));
  GtkWidget *checkbutton_frequencies=gtk_check_button_new_with_mnemonic (_("Frequencies (Hz)"));
  char tmpstring[64];
  sprintf (tmpstring, "%g", roundoff);
  gtk_entry_set_text (GTK_ENTRY (entry_input_roundingval), tmpstring);

  // Add the label, and show everything we've added to the dialog. 
  gtk_container_add (GTK_CONTAINER (GTK_DIALOG (dialog)->vbox), label_roundingval);
  gtk_container_add (GTK_CONTAINER (GTK_DIALOG (dialog)->vbox), entry_input_roundingval);
  gtk_container_add (GTK_CONTAINER (GTK_DIALOG (dialog)->vbox), label_text);
  gtk_container_add (GTK_CONTAINER (GTK_DIALOG (dialog)->vbox), checkbutton_durations);  
  gtk_container_add (GTK_CONTAINER (GTK_DIALOG (dialog)->vbox), checkbutton_frequencies);  
  gtk_widget_show_all (dialog);

  //block until I get a response:
  gint result = gtk_dialog_run (GTK_DIALOG (dialog));
  switch (result)
    {
    case GTK_RESPONSE_ACCEPT:
      {
       roundoff = atof (gtk_entry_get_text (GTK_ENTRY (entry_input_roundingval)));
       if (roundoff <= 0)	break;
       //backup data:
       bbl_BackupDataPoints();
       ScheduleGUI_ProgressIndicatorFlag=FALSE;
       bbl_ScheduleGUI_RoundValues(roundoff, 
       gtk_toggle_button_get_active ((GtkToggleButton *)checkbutton_durations),
       gtk_toggle_button_get_active ((GtkToggleButton *)checkbutton_frequencies)); 
      	break;
      }
	
	default:
    break;
    }
  gtk_widget_destroy (dialog);
}


//==========================
void on_graph_copy1_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
 ScheduleGUI_CopySelectedDataPoints(lookup_widget (GTK_WIDGET (window1), "drawingarea1"));
}



//==========================
void on_graph_paste1_activate(GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
 bbl_BackupDataPoints();
 ScheduleGUI_PasteSelectedDataPoints(lookup_widget(GTK_WIDGET (window1), "drawingarea1"), TRUE);
  bbl_ScheduleGUI_redraw(FALSE);
}



//==========================
void on_graph_set1_activate(GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
 static double tmpd=6.0;
 GtkWidget *dialog = gtk_dialog_new_with_buttons ("Set DataPoint Values",
       NULL,
			   //(GtkWindow*) widget,
			   (GtkDialogFlags)
			   (GTK_DIALOG_MODAL |
			    GTK_DIALOG_DESTROY_WITH_PARENT),
			   GTK_STOCK_OK,
			   GTK_RESPONSE_ACCEPT,
			   GTK_STOCK_CANCEL,
			   GTK_RESPONSE_REJECT,
			   NULL);

//add some stuff:
  GtkWidget *label_input_set = gtk_label_new ("Set to:");
  GtkWidget *entry_input_set_to = gtk_entry_new ();
  GtkWidget *label_text = gtk_label_new ("Apply to:");
  GtkWidget *checkbutton_durations=gtk_check_button_new_with_mnemonic (_("Durations (Sec.)"));
  GtkWidget *checkbutton_frequencies=gtk_check_button_new_with_mnemonic (_("Frequencies (Hz)"));
  GtkWidget *label_text2 = gtk_label_new ("Add to current values?:");
  GtkWidget *checkbutton_add=gtk_check_button_new_with_mnemonic (_("Yes"));
  char tmpstring[64];
  sprintf (tmpstring, "%g",tmpd);
  gtk_entry_set_text (GTK_ENTRY (entry_input_set_to), tmpstring);

  // Add the label, and show everything we've added to the dialog. 
  gtk_container_add (GTK_CONTAINER (GTK_DIALOG (dialog)->vbox), label_input_set);
  gtk_container_add (GTK_CONTAINER (GTK_DIALOG (dialog)->vbox), entry_input_set_to);
  gtk_container_add (GTK_CONTAINER (GTK_DIALOG (dialog)->vbox), label_text);
  gtk_container_add (GTK_CONTAINER (GTK_DIALOG (dialog)->vbox), checkbutton_durations);  
  gtk_container_add (GTK_CONTAINER (GTK_DIALOG (dialog)->vbox), checkbutton_frequencies);  
  gtk_container_add (GTK_CONTAINER (GTK_DIALOG (dialog)->vbox), label_text2);
  gtk_container_add (GTK_CONTAINER (GTK_DIALOG (dialog)->vbox), checkbutton_add);  
  gtk_widget_show_all (dialog);

  //block until I get a response:
  gint result = gtk_dialog_run (GTK_DIALOG (dialog));
  switch (result)
    {
    case GTK_RESPONSE_ACCEPT:
      {       
       //set values:
       gboolean dur = gtk_toggle_button_get_active ((GtkToggleButton *)checkbutton_durations);
       gboolean  hz = gtk_toggle_button_get_active ((GtkToggleButton *)checkbutton_frequencies); 
       gboolean add = gtk_toggle_button_get_active ((GtkToggleButton *)checkbutton_add); 

       tmpd = atof (gtk_entry_get_text (GTK_ENTRY (entry_input_set_to)));\

       //backup data:
       bbl_BackupDataPoints();
       ScheduleGUI_ProgressIndicatorFlag=FALSE;
       
       DataPoint * curDP = ScheduleGUI_FirstDataPoint;
       do {
        if (curDP->state == SCHEDULEGUI_SELECTED)  {
         if (dur == TRUE) {
          if (add == TRUE) curDP->duration+=tmpd;
          else curDP->duration=tmpd;
          if (curDP->duration < 0) curDP->duration=0;
         }
         
         if (hz == TRUE) {
         if (add == TRUE) curDP->hz+=tmpd;
         else curDP->hz=tmpd;
         if (curDP->hz < 0) curDP->hz=0;
         }
        }
         curDP=curDP->NextDataPoint;
       }while (curDP != NULL);
       //end set values.
       
      bbl_ScheduleGUI_redraw(TRUE);
     	break;
      }
	
	default:
    break;
    }
  gtk_widget_destroy (dialog);

}


//==========================
void on_graph_scale1_activate (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  static double tmpd=.75;
 GtkWidget *dialog = gtk_dialog_new_with_buttons ("Scale DataPoint Values",
       NULL,
			   //(GtkWindow*) widget,
			   (GtkDialogFlags)
			   (GTK_DIALOG_MODAL |
			    GTK_DIALOG_DESTROY_WITH_PARENT),
			   GTK_STOCK_OK,
			   GTK_RESPONSE_ACCEPT,
			   GTK_STOCK_CANCEL,
			   GTK_RESPONSE_REJECT,
			   NULL);

//add some stuff:
  GtkWidget *label_input_var = gtk_label_new ("Scale by:");
  GtkWidget *entry_input_var = gtk_entry_new ();
  GtkWidget *label_text = gtk_label_new ("Apply to:");
  GtkWidget *checkbutton_durations=gtk_check_button_new_with_mnemonic (_("Durations (Sec.)"));
  GtkWidget *checkbutton_frequencies=gtk_check_button_new_with_mnemonic (_("Frequencies (Hz)"));
//  GtkWidget *label_text2 = gtk_label_new ("Add to current values?:");
//  GtkWidget *checkbutton_text2=gtk_check_button_new_with_mnemonic (_("Yes"));
  char tmpstring[64];
  sprintf (tmpstring, "%g",tmpd);
  gtk_entry_set_text (GTK_ENTRY (entry_input_var), tmpstring);

  // Add the label, and show everything we've added to the dialog. 
  gtk_container_add (GTK_CONTAINER (GTK_DIALOG (dialog)->vbox), label_input_var);
  gtk_container_add (GTK_CONTAINER (GTK_DIALOG (dialog)->vbox), entry_input_var);
  gtk_container_add (GTK_CONTAINER (GTK_DIALOG (dialog)->vbox), label_text);
  gtk_container_add (GTK_CONTAINER (GTK_DIALOG (dialog)->vbox), checkbutton_durations);  
  gtk_container_add (GTK_CONTAINER (GTK_DIALOG (dialog)->vbox), checkbutton_frequencies);  
//  gtk_container_add (GTK_CONTAINER (GTK_DIALOG (dialog)->vbox), label_text2);
//  gtk_container_add (GTK_CONTAINER (GTK_DIALOG (dialog)->vbox), checkbutton_text2);  
  gtk_widget_show_all (dialog);

  //block until I get a response:
  gint result = gtk_dialog_run (GTK_DIALOG (dialog));
  switch (result)
    {
    case GTK_RESPONSE_ACCEPT:
      {
       //set values:
       gboolean dur = gtk_toggle_button_get_active ((GtkToggleButton *)checkbutton_durations);
       gboolean  hz = gtk_toggle_button_get_active ((GtkToggleButton *)checkbutton_frequencies); 
  //     gboolean add = gtk_toggle_button_get_active ((GtkToggleButton *)checkbutton_text2); 

       tmpd = atof (gtk_entry_get_text (GTK_ENTRY (entry_input_var)));

       //backup data:
       bbl_BackupDataPoints();
       ScheduleGUI_ProgressIndicatorFlag=FALSE;
       
       DataPoint * curDP = ScheduleGUI_FirstDataPoint;
       do {
        if (curDP->state == SCHEDULEGUI_SELECTED)  {
         if (dur == TRUE) {
            curDP->duration*=tmpd;
          if (curDP->duration < 0) curDP->duration=0;
         }
         if (hz == TRUE)   {
          curDP->hz*=tmpd;
          if (curDP->hz < 0) curDP->hz=0;
         }
        }
         curDP=curDP->NextDataPoint;
       } while (curDP != NULL);
       //end set values.
       
      bbl_ScheduleGUI_redraw(TRUE);
      }
     	break;

      
	default:
    break;
    }
  gtk_widget_destroy (dialog);
}


//==========================
void on_graph_add_noise1_activate(GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  static double tmpd=.25;
 GtkWidget *dialog = gtk_dialog_new_with_buttons ("Add Noise",
       NULL,
			   //(GtkWindow*) widget,
			   (GtkDialogFlags)
			   (GTK_DIALOG_MODAL |
			    GTK_DIALOG_DESTROY_WITH_PARENT),
			   GTK_STOCK_OK,
			   GTK_RESPONSE_ACCEPT,
			   GTK_STOCK_CANCEL,
			   GTK_RESPONSE_REJECT,
			   NULL);

//add some stuff:
  GtkWidget *label_input_var = gtk_label_new ("+/- Range:");
  GtkWidget *entry_input_var = gtk_entry_new ();
  GtkWidget *label_text = gtk_label_new ("Apply to:");
  GtkWidget *checkbutton_durations=gtk_check_button_new_with_mnemonic (_("Durations (Sec.)"));
  GtkWidget *checkbutton_frequencies=gtk_check_button_new_with_mnemonic (_("Frequencies (Hz)"));
//  GtkWidget *label_text2 = gtk_label_new ("Add to current values?:");
//  GtkWidget *checkbutton_text2=gtk_check_button_new_with_mnemonic (_("Yes"));
  char tmpstring[64];
  sprintf (tmpstring, "%g",tmpd);
  gtk_entry_set_text (GTK_ENTRY (entry_input_var), tmpstring);

  // Add the label, and show everything we've added to the dialog. 
  gtk_container_add (GTK_CONTAINER (GTK_DIALOG (dialog)->vbox), label_input_var);
  gtk_container_add (GTK_CONTAINER (GTK_DIALOG (dialog)->vbox), entry_input_var);
  gtk_container_add (GTK_CONTAINER (GTK_DIALOG (dialog)->vbox), label_text);
  gtk_container_add (GTK_CONTAINER (GTK_DIALOG (dialog)->vbox), checkbutton_durations);  
  gtk_container_add (GTK_CONTAINER (GTK_DIALOG (dialog)->vbox), checkbutton_frequencies);  
//  gtk_container_add (GTK_CONTAINER (GTK_DIALOG (dialog)->vbox), label_text2);
//  gtk_container_add (GTK_CONTAINER (GTK_DIALOG (dialog)->vbox), checkbutton_text2);  
  gtk_widget_show_all (dialog);

  //block until I get a response:
  gint result = gtk_dialog_run (GTK_DIALOG (dialog));
  switch (result)
    {
    case GTK_RESPONSE_ACCEPT:
      {
       //set values:
       gboolean dur = gtk_toggle_button_get_active ((GtkToggleButton *)checkbutton_durations);
       gboolean  hz = gtk_toggle_button_get_active ((GtkToggleButton *)checkbutton_frequencies); 
  //     gboolean add = gtk_toggle_button_get_active ((GtkToggleButton *)checkbutton_text2); 

       tmpd = atof (gtk_entry_get_text (GTK_ENTRY (entry_input_var)));

       //backup data:
       bbl_BackupDataPoints();
       ScheduleGUI_ProgressIndicatorFlag=FALSE;
       
       DataPoint * curDP = ScheduleGUI_FirstDataPoint;
       do {
        if (curDP->state == SCHEDULEGUI_SELECTED)  {
         if (dur == TRUE) {
            curDP->duration+=g_random_double_range (-tmpd,tmpd);
          if (curDP->duration < 0) curDP->duration=0;
         }
         if (hz == TRUE)   {
          curDP->hz+=g_random_double_range (-tmpd,tmpd);
          if (curDP->hz < 0) curDP->hz=0;
         }
        }
         curDP=curDP->NextDataPoint;
       } while (curDP != NULL);
       //end set values.
       
      bbl_ScheduleGUI_redraw(TRUE);
      }
     	break;

      
	default:
    break;
    }
  gtk_widget_destroy (dialog);
}


//==========================
void on_graph1_select_previous_points1_activate
                                        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  bbl_BackupDataPoints();
 ScheduleGUI_SelectNeighboringDataPoints(FALSE,TRUE);
 bbl_ScheduleGUI_redraw(FALSE);
}


//==========================
void on_graph1_select_next_points1_activate (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  bbl_BackupDataPoints();
 ScheduleGUI_SelectNeighboringDataPoints(TRUE,TRUE);
 bbl_ScheduleGUI_redraw(FALSE);
}

//==========================
void on_graph_select1_activate              (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  bbl_BackupDataPoints();
 ScheduleGUI_SelectAllDataPoints();
 bbl_ScheduleGUI_redraw(FALSE);
}

//==========================
void on_graph_deselect1_activate            (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  bbl_BackupDataPoints();
 ScheduleGUI_DeselectDataPoints();
 bbl_ScheduleGUI_redraw(FALSE);
}


//==========================
void on_graph_cut1_activate(GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
   bbl_BackupDataPoints();
   ScheduleGUI_ProgressIndicatorFlag=FALSE;
   ScheduleGUI_CopySelectedDataPoints(lookup_widget (GTK_WIDGET (window1), "drawingarea1")); 
   ScheduleGUI_DeleteSelectedPoints(lookup_widget (GTK_WIDGET (window1), "drawingarea1"), FALSE);
  bbl_ScheduleGUI_redraw(FALSE);
 }


//==========================
void on_graph_cut_time1_activate(GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  bbl_BackupDataPoints();
 ScheduleGUI_ProgressIndicatorFlag=FALSE;
  ScheduleGUI_CopySelectedDataPoints(lookup_widget (GTK_WIDGET (window1), "drawingarea1"));  
  ScheduleGUI_DeleteSelectedPoints(lookup_widget (GTK_WIDGET (window1), "drawingarea1"), TRUE);
  bbl_ScheduleGUI_redraw(FALSE);
}


//==========================
void on_graph_delete1_activate(GtkMenuItem *menuitem,  gpointer  user_data)
{
 bbl_BackupDataPoints();
 ScheduleGUI_ProgressIndicatorFlag=FALSE;
 ScheduleGUI_DeleteSelectedPoints(lookup_widget (GTK_WIDGET (window1), "drawingarea1"), FALSE);
  bbl_ScheduleGUI_redraw(FALSE);
}


//==========================
void on_graph_delete_time1_activate(GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
   bbl_BackupDataPoints();
   ScheduleGUI_ProgressIndicatorFlag=FALSE;
   ScheduleGUI_DeleteSelectedPoints(lookup_widget (GTK_WIDGET (window1), "drawingarea1"), TRUE); 
   bbl_ScheduleGUI_redraw(FALSE);

}




//==========================
void on_graph_invert_selection1_activate    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    bbl_BackupDataPoints();
 ScheduleGUI_InvertSelectionAllDataPoints();
 bbl_ScheduleGUI_redraw(FALSE);
}


//==========================
void on_graph_select_interval1_activate     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
   static int tmpd=2;
 GtkWidget *dialog = gtk_dialog_new_with_buttons ("Selection Interval",
       NULL,
			   //(GtkWindow*) widget,
			   (GtkDialogFlags)
			   (GTK_DIALOG_MODAL |
			    GTK_DIALOG_DESTROY_WITH_PARENT),
			   GTK_STOCK_OK,
			   GTK_RESPONSE_ACCEPT,
			   GTK_STOCK_CANCEL,
			   GTK_RESPONSE_REJECT,
			   NULL);

//add some stuff:
  GtkWidget *label_input_var = gtk_label_new ("Interval:");
  GtkWidget *entry_input_var = gtk_entry_new ();
  GtkWidget *checkbutton_deselect=gtk_check_button_new_with_mnemonic (_("Deselect Others"));
  char tmpstring[64];
  sprintf (tmpstring, "%d",tmpd);
  gtk_entry_set_text (GTK_ENTRY (entry_input_var), tmpstring);

  // Add the label, and show everything we've added to the dialog. 
  gtk_container_add (GTK_CONTAINER (GTK_DIALOG (dialog)->vbox), label_input_var);
  gtk_container_add (GTK_CONTAINER (GTK_DIALOG (dialog)->vbox), entry_input_var);
  gtk_container_add (GTK_CONTAINER (GTK_DIALOG (dialog)->vbox), checkbutton_deselect);  
  gtk_widget_show_all (dialog);

  //block until I get a response:
  gint result = gtk_dialog_run (GTK_DIALOG (dialog));
  switch (result)
    {
    case GTK_RESPONSE_ACCEPT:
      {
       //set values:
       tmpd = atoi(gtk_entry_get_text (GTK_ENTRY (entry_input_var)));

     //backup data:
     bbl_BackupDataPoints();
       
     ScheduleGUI_SelectIntervalAllDataPoints(tmpd, gtk_toggle_button_get_active ((GtkToggleButton *)checkbutton_deselect));
       
      bbl_ScheduleGUI_redraw(FALSE);
      }
     	break;

      
	default:
    break;
    }
  gtk_widget_destroy (dialog);
}


//==========================
void on_graph_delete_duplicates1_activate   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    static double tmpd=.1;
 GtkWidget *dialog = gtk_dialog_new_with_buttons ("Delete Duplicate Datapoints",
       NULL,
			   //(GtkWindow*) widget,
			   (GtkDialogFlags)
			   (GTK_DIALOG_MODAL |
			    GTK_DIALOG_DESTROY_WITH_PARENT),
			   GTK_STOCK_OK,
			   GTK_RESPONSE_ACCEPT,
			   GTK_STOCK_CANCEL,
			   GTK_RESPONSE_REJECT,
			   NULL);

//add some stuff:
  GtkWidget *label_input_var = gtk_label_new ("Threshold (0 to 128):");
  GtkWidget *entry_input_var = gtk_entry_new ();
  char tmpstring[64];
  sprintf (tmpstring, "%g",tmpd);
  gtk_entry_set_text (GTK_ENTRY (entry_input_var), tmpstring);

  // Add the label, and show everything we've added to the dialog. 
  gtk_container_add (GTK_CONTAINER (GTK_DIALOG (dialog)->vbox), label_input_var);
  gtk_container_add (GTK_CONTAINER (GTK_DIALOG (dialog)->vbox), entry_input_var);
  gtk_widget_show_all (dialog);

  //block until I get a response:
  gint result = gtk_dialog_run (GTK_DIALOG (dialog));
  switch (result)
    {
    case GTK_RESPONSE_ACCEPT:
      {
       //set values:
       tmpd = atof(gtk_entry_get_text (GTK_ENTRY (entry_input_var)));       

       //backup data:
       bbl_BackupDataPoints();
       ScheduleGUI_ProgressIndicatorFlag=FALSE;
       ScheduleGUI_DeleteDuplicateDataPoints(lookup_widget (GTK_WIDGET (window1), "drawingarea1"),tmpd);
      }
     	break;

      
	default:
    break;
    }
  gtk_widget_destroy (dialog);
}
