#ifndef __GM_MCP_H__
#define __GM_MCP_H__

#include <glib.h>
#include "gm-mcp.h"

#define MCP_MIN_VERSION 2.1
#define MCP_MAX_VERSION 2.1

typedef struct _McpMessageInfo {
  gchar *name;
  gchar *authkey;
  GList *fields;
} McpMessageInfo;

gdouble gm_mcp_get_version(gdouble client_min, gdouble client_max,
		gdouble server_min,	gdouble server_max);
gchar const *gm_mcp_find_value(GList const *fields, gchar const *key);
gchar *gm_mcp_escape_if_needed(gchar const *line);
gchar *gm_mcp_un_escape(gchar *line);
GList *gm_mcp_process_key_values(gchar const *line);
gboolean gm_mcp_parse_line(gchar *line, McpMessageInfo *info);
gchar *gm_mcp_generate_data_tag();
gchar *gm_mcp_generate_auth_key();
gchar const *gm_mcp_find_multiline_tag(GList const *fields);
void gm_mcp_destroy_fields(GList *fields);
GList *gm_mcp_parse_list(gchar const *s);
void gm_mcp_list_free(GList *list);

#endif /* __GM_MCP_H__ */
