#ifndef __GM_WORLDS_VIEW_H__
#define __GM_WORLDS_VIEW_H__

#include <gtk/gtk.h>

G_BEGIN_DECLS

/*
 * Type checking and casting macros
 */
#define GM_TYPE_WORLDS_VIEW					(gm_worlds_view_get_type())
#define GM_WORLDS_VIEW(obj)					(G_TYPE_CHECK_INSTANCE_CAST((obj), \
		GM_TYPE_WORLDS_VIEW, GmWorldsView))
#define GM_WORLDS_VIEW_CONST(obj)			(G_TYPE_CHECK_INSTANCE_CAST((obj), \
		GM_TYPE_WORLDS_VIEW, GmWorldsView const))
#define GM_WORLDS_VIEW_CLASS(klass)			(G_TYPE_CHECK_CLASS_CAST((klass), \
		GM_TYPE_WORLDS_VIEW, GmWorldsViewClass))
#define GM_IS_WORLDS_VIEW(obj)				(G_TYPE_CHECK_INSTANCE_TYPE((obj), \
		GM_TYPE_WORLDS_VIEW))
#define GM_IS_WORLDS_VIEW_CLASS(klass)		(G_TYPE_CHECK_CLASS_TYPE ((klass), \
		GM_TYPE_WORLDS_VIEW))
#define GM_WORLDS_VIEW_GET_CLASS(obj)		(G_TYPE_INSTANCE_GET_CLASS((obj), \
		GM_TYPE_WORLDS_VIEW, GmWorldsViewClass))

enum {
  GM_WORLDS_VIEW_LOGO_COLUMN,
  GM_WORLDS_VIEW_NAME_COLUMN,
  GM_WORLDS_VIEW_WORLD_COLUMN,
  GM_WORLDS_VIEW_SORT_COLUMN,
  GM_WORLDS_VIEW_N_COLUMNS
};

/* Private structure type */
typedef struct _GmWorldsViewPrivate GmWorldsViewPrivate;

/*
 * Main object structure
 */
typedef struct _GmWorldsView GmWorldsView;
 
struct _GmWorldsView {
	GtkTreeView parent;
	
	/*< private > */
	GmWorldsViewPrivate *priv;
};

/*
 * Class definition
 */
typedef struct _GmWorldsViewClass 	GmWorldsViewClass;

struct _GmWorldsViewClass {
	GtkTreeViewClass parent_class;

	/* Signals
	void (* proto) (GmWorldsView *obj); */
};

GType gm_worlds_view_get_type(void) G_GNUC_CONST;
GtkWidget *gm_worlds_view_new();

void gm_worlds_view_add_world(GmWorldsView *view, GmWorld *world);
GtkTreeModel *gm_worlds_view_model(GmWorldsView *view);

G_END_DECLS
#endif /* __GM_WORLDS_VIEW_H__ */
