/*
 * GNoise
 *
 * Copyright (C) 1999-2001 Dwight Engen
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: dlglevels.c,v 1.5 2001/02/24 02:42:35 dengen Exp $
 *
 */

#include <gtk/gtk.h>
#include "gnoise.h"
#include "gtklevels.h"
#include "oss.h"

void on_dlglevels(GtkMenuItem *menuitem, gpointer user_data)
{
    if ((!file_open) || (win_levels != NULL))
	return;

    win_levels = create_LevelsDialog();
    gtk_widget_show(win_levels);
}

gboolean on_dlglevels_destroy(GtkWidget *widget, GdkEvent *event, gpointer user_data)
{
    win_levels = NULL;
    return FALSE;
}

void dlglevels_update(void)
{
    GtkLevels *Levels;

    if (win_levels == NULL)
	return;

    Levels = GTK_LEVELS(lookup_widget(win_levels, "Levels"));
    gtk_levels_set_levels(Levels, lpeak, rpeak);

    if (lclip)
    {
	gtk_levels_set_clip(Levels, 0);
	lclip = FALSE;
    }
    if (rclip)
    {
	gtk_levels_set_clip(Levels, 1);
	rclip = FALSE;
    }
}
