/*
 * Main game iteration, and misc functions
 *
 * Copyright (c) 2000 Michael Pearson <alcaron@senet.com.au>
 *
 * This file is licensed under the GNU General Public License. See the file
 * "COPYING" for more details.
 */

typedef enum { 
	PAUSE_MENU =    0x00000001, 
	PAUSE_FOCUS =   0x00000002, 
	PAUSE_POINTER = 0x00000004,
	PAUSE_PREF =    0x00000008
} PauseType;

void iterate_game(Game *game);
void lose_life(Game *game);
void run_game(Game *game);
void pause_game(Game *game, PauseType type, gboolean unpause);
void end_game(Game *game);
void next_level(Game *game);
void key_left_pressed(Game *game);
void key_left_released(Game *game);
void key_right_pressed(Game *game);
void key_right_released(Game *game);
void key_fire1_pressed(Game *game);
void key_fire1_released(Game *game);
void key_fire2_pressed(Game *game);
void key_fire2_released(Game *game);
void mouse_moved(Game *game, int position);
void new_life(Game *game);
