/* vi:set ts=8 sts=0 sw=8:
 * $Id: msgbar.c,v 1.4 2001/01/25 06:01:38 kahn Exp kahn $
 *
 * Copyright (C) 2000 Andy C. Kahn
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include <stdarg.h>
#include <string.h>
#include "main.h"
#ifdef USE_GNOME
#include <gnome.h>
#endif
#include "win.h"
#include "msgbar.h"


static int msgbar_clear(gpointer data);


/*** global function definitions ***/
/*
 * PUBLIC: msgbar_printf
 *
 * sets the message/status bar.  remembers the last message set so that a
 * duplicate one won't be set on top of the current one.
 */
void
msgbar_printf(win_t *w, const char *fmt, ...)
{
	va_list args;
	char *msg;

	va_start(args, fmt);
	msg = g_strdup_vprintf(fmt, args);
	va_end(args);
	if (w->lastmsg == NULL || (w->lastmsg && strcmp(w->lastmsg, msg))) {
		if (w->lastmsg && w->timeout_id > 0)
			gtk_timeout_remove(w->timeout_id);
		gnome_appbar_set_status(GNOME_APPBAR(w->msgbar), msg);
		g_free(w->lastmsg);
		w->lastmsg = msg;
		w->timeout_id = gtk_timeout_add(
					5000, (GtkFunction)msgbar_clear, w);
	} else {
		g_free(msg);
	}
} /* msgbar_printf */


/*
 * PRIVATE: msgbar_clear
 *
 * clears the text by using a space (" ").  apparently, Gtk has no provision
 * for clearing a label widget.
 */
static int
msgbar_clear(gpointer data)
{
	win_t *w = (win_t *)data;

	msgbar_printf(w, " ");
	return FALSE;
} /* msgbar_clear */


/* the end */
