--[[
	Hearts - stock_ai.lua
	Copyright 2006 Sander Marechal
	
	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.
	
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
	
	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
]]

math.randomseed = os.time()
valid_cards = {}

-- remove card from hand and add it to result
function select_card(card, result, hand)
	local i = have_card(card, hand)

	if i then
		table.insert(result, card)
		table.remove(hand, i)
	end
end

function play_card()
	local valid_cards = get_valid_cards(hand)
	
	if trick_get_num_played() == 0 then
		-- open with the lowest valid card
		table.sort(valid_cards, ascending)
		return valid_cards[1]
	elseif trick_get_num_played() == 3 then
		if trick_get_score() == 0 then
			-- play the highest card that's not a point
			local pointless_cards = get_pointless_cards(valid_cards)
			if table.getn(pointless_cards) > 0 then
				table.sort(pointless_cards, descending)
				return pointless_cards[1]
			else
				table.sort(valid_cards, descending)
				return valid_cards[1]
			end
		else
			-- play the higest card that doesn't take the trick
			local high_card = get_highest_card()
			table.sort(valid_cards, descending)
			for _, card in ipairs(valid_cards) do
				if card[suit] ~= high_card[suit] or card[rank] < high_card[rank] then
					return card
				end
			end
			-- we can't dodge, so take it with the higest card
			return valid_cards[1]
		end
	else
		local trump = trick_get_trump()
		local trump_cards = get_cards_of_suit(valid_cards, trump)
		if table.getn(trump_cards) == 0 then
			-- if we can't follow the suit, dump the highest point card
			local point_cards = get_point_cards(valid_cards)
			if table.getn(point_cards) > 0 then
				table.sort(point_cards, points_descending)
				return point_cards[1]
			end
		else
			-- we must follow the suit
			if trick_get_score() > 0 then
				-- play the higest card that doesn't take the trick
				local high_card = get_highest_card()
				table.sort(valid_cards, descending)
				for _, card in ipairs(valid_cards) do
					if card[suit] ~= high_card[suit] or card[rank] < high_card[rank] then
						return card
					end
				end
				-- we can't dodge, so take it with the lowest card
				table.sort(valid_cards, ascending)
				return valid_cards[1]
			end
		end
	end
	
	i = math.random(table.getn(valid_cards))
	return (valid_cards[i])
end

function select_cards()
	local result = {}
	local index = 0
	
	-- first pass on the high spades
	if have_card({spades, ace_high}, hand) then select_card({spades, ace_high}, result, hand) end
	if have_card({spades, king},     hand) then select_card({spades, king},     result, hand) end
	if have_card({spades, queen},    hand) then select_card({spades, queen},    result, hand) end
	
	-- pass off other cards
	while table.getn(result) < 3 do
		local clubs_list    = get_cards_of_suit(hand, clubs)
		local diamonds_list = get_cards_of_suit(hand, diamonds)
		local spades_list   = get_cards_of_suit(hand, spades)
		local hearts_list   = get_cards_of_suit(hand, hearts)
		
		-- if we can clear a suit with one card then do so, else pick a hearts or a high card
		if     table.getn(clubs_list)    == 1 then select_card(clubs_list[1],    result, hand)
		elseif table.getn(diamonds_list) == 1 then select_card(diamonds_list[1], result, hand)
		elseif table.getn(hearts_list) > 0 then
			table.sort(hearts_list, descending)
			select_card(hearts_list[1], result, hand)
		else
			table.sort(hand, descending)
			select_card(hand[1], result, hand)
		end
	end
	return result
end
