/*
 *  Hearts - player-api.h
 *  Copyright 2006 Sander Marechal
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#ifndef PLAYER_API_H
#define PLAYER_API_H

#include <glib.h>
#include <lua.h>
#include <lualib.h>
#include <lauxlib.h>

#include "cards.h"

void stack_dump (lua_State *L);

/* C functions that will get exposed to Lua */
gint lua_trick_get_winner (lua_State *state);
gint lua_trick_get_trump (lua_State *state);
gint lua_trick_get_num_played(lua_State *state);
gint lua_trick_get_score (lua_State *state);
gint lua_is_valid_card (lua_State *state);

/* Functions for manipulating states */
lua_State* lua_state_init(void);
Card* lua_pop_card(lua_State *state);

#endif /* PLAYER_API_H */
