#ifndef _GP_CHARACTER_BLOCK_H_
#define _GP_CHARACTER_BLOCK_H_

/*
 * Unicode character blocks
 *
 * Authors:
 *   Lauris Kaplinski <lauris@helixcode.com>
 *
 * Copyright (C) 2000 Helix Code, Inc.
 *
 */

#include <glib.h>
#include <libgnome/gnome-defs.h>

BEGIN_GNOME_DECLS

typedef struct _GPCharBlock GPCharBlock;
typedef struct _GPUCMapEntry GPUCMapEntry;
typedef struct _GPUCMap GPUCMap;

typedef enum {
	/* General scripts */
	GP_CB_BASIC_LATIN,
	GP_CB_LATIN_1_SUPPLEMENT,
	GP_CB_LATIN_EXTENDED_A,
	GP_CB_LATIN_EXTENDED_B,
	GP_CB_IPA_EXTENSIONS,
	GP_CB_SPACING_MODIFIER_LETTERS,
	GP_CB_COMBINING_DIACRITICAL_MARKS,
	GP_CB_GREEK,
	GP_CB_CYRILLIC,
	GP_CB_ARMENIAN,
	GP_CB_HEBREW,
	GP_CB_ARABIC,
	GP_CB_SYRIAC,
	GP_CB_THAANA,
	GP_CB_DEVANAGARI,
	GP_CB_BENGALI,
	GP_CB_GURMUKHI,
	GP_CB_GUJARATI,
	GP_CB_ORIYA,
	GP_CB_TAMIL,
	GP_CB_TELUGU,
	GP_CB_KANNADA,
	GP_CB_MALAYALAM,
	GP_CB_SINHALA,
	GP_CB_THAI,
	GP_CB_LAO,
	GP_CB_TIBETAN,
	GP_CB_MYANMAR,
	GP_CB_GEORGIAN,
	GP_CB_HANGUL_JAMO,
	GP_CB_ETHIOPIC,
	GP_CB_CHEROKEE,
	GP_CB_U_C_A_S,
	GP_CB_OGHAM,
	GP_CB_RUNIC,
	GP_CB_KHMER,
	GP_CB_MONGOLIAN,
	GP_CB_LATIN_EXTENDED_ADDITIONAL,
	GP_CB_GREEK_EXTENDED,
	/* Symbols area */
	GP_CB_GENERAL_PUNCTUATION,
	GP_CB_SUPERSCRIPTS_AND_SUBSCRIPTS,
	GP_CB_CURRENCY_SYMBOLS,
	GP_CB_COMBINING_MARKS_FOR_SYMBOLS,
	GP_CB_LETTERLIKE_SYMBOLS,
	GP_CB_NUMBER_FORMS,
	GP_CB_ARROWS,
	GP_CB_MATHEMATICAL_OPERATORS,
	GP_CB_MISCELLANEOUS_TECHNICAL,
	GP_CB_CONTROL_PICTURES,
	GP_CB_O_C_R,
	GP_CB_ENCLOSED_ALPHANUMERICS,
	GP_CB_BOX_DRAWING,
	GP_CB_BLOCK_ELEMENTS,
	GP_CB_GEOMETRIC_SHAPES,
	GP_CB_MISCELLANEOUS_SYMBOLS,
	GP_CB_DINGBATS,
	GP_CB_BRAILLE_PATTERNS,
	/* CJK Phonetics and Symbols Area */
	GP_CB_CJK_RADICALS_SUPPLEMENT,
	GP_CB_KANGXI_RADICALS,
	GP_CB_IDEOGRAPHIC_DESCRIPTION_CHARACTERS,
	GP_CB_CJK_SYMBOLS_AND_PUNCTUATION,
	GP_CB_HIRAGANA,
	GP_CB_KATAKANA,
	GP_CB_BOPOMOFO,
	GP_CB_HANGUL_COMPATIBILITY_JAMO,
	GP_CB_KANBUN,
	GP_CB_BOPOMOFO_EXTENDED,
	GP_CB_ENCLOSED_CJK_LETTERS_AND_MONTHS,
	GP_CB_CJK_COMPATIBILITY,
	/* CJK Ideographs */
	GP_CB_CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A,
	GP_CB_CJK_UNIFIED_IDEOGRAPHS,
	/* Yi Syllables */
	GP_CB_YI_SYLLABLES,
	GP_CB_YI_RADICALS,
	/* Hangul Syllables */
	GP_CB_HANGUL_SYLLABLES,
	/* Surrogates */
	GP_CB_HIGH_SURROGATES,
	GP_CB_HIGH_PRIVATE_USE_SURROGATES,
	GP_CB_LOW_SURROGATES,
	/* Private Use */
	GP_CB_PRIVATE_USE,
	/* Compatibility and specials */
	GP_CB_CJK_COMPATIBILITY_IDEOGRAPHS,
	GP_CB_ALPHABETIC_PRESENTATION_FORMS,
	GP_CB_ARABIC_PRESENTATION_FORMS_A,
	GP_CB_COMBINING_HALF_MARKS,
	GP_CB_CJK_COMPATIBILITY_MARKS,
	GP_CB_SMALL_FORM_VARIANTS,
	GP_CB_ARABIC_PRESENTATION_FORMS_B,
	GP_CB_SPECIALS_1,
	GP_CB_HALFWIDTH_AND_FULLWIDTH_FORMS,
	GP_CB_SPECIALS_2,
	GP_CB_END
} GPCharBlockCode;

struct _GPCharBlock {
	GPCharBlockCode code;
	gint first;
	gint last;
};

struct _GPUCMapEntry {
	const GPCharBlock * block;
	gint mapped;
	gint * glyphs;
};

struct _GPUCMap {
	gint refcount;
	GPUCMapEntry * entry[GP_CB_END];
};

const GPCharBlock * gp_unicode_get_char_block (gint unival);

GPUCMap * gp_uc_map_new (void);
void gp_uc_map_ref (GPUCMap * map);
void gp_uc_map_unref (GPUCMap * map);

void gp_uc_map_insert (GPUCMap * map, gint unicode, gint glyph);
gint gp_uc_map_lookup (GPUCMap * map, gint unicode);

END_GNOME_DECLS

#endif

