#include "common.h"
#include <bluetooth/bluetooth.h>
#include <bluetooth/hci.h>
#include <sys/ioctl.h>
#include <stdlib.h>
#include <assert.h>
#include <bluetooth/rfcomm.h>
#include <gw-obex.h>
#include <errno.h>
#include <unistd.h>

void get_dev(char addr[18])
{
	int ctl = socket(AF_BLUETOOTH, SOCK_RAW, BTPROTO_HCI);
	assert(ctl >= 0);

	int r;
	struct hci_dev_info di;
	memset(&di, 0, sizeof(di));

	struct hci_dev_list_req *dl = malloc(HCI_MAX_DEV * sizeof(struct hci_dev_req) + sizeof(uint16_t));
	dl->dev_num = HCI_MAX_DEV;
	r = ioctl(ctl, HCIGETDEVLIST, (void *) dl);
	assert(r >= 0);

	struct hci_dev_req *dr = dl->dev_req;
	di.dev_id = dr->dev_id;
	r = ioctl(ctl, HCIGETDEVINFO, (void *) &di);
	assert(r >= 0);

	ba2str(&di.bdaddr, addr);
	free(dl);
}

static int get_sock(void) {
	int sock;
	int err = -1;
	do {
		sock = socket(AF_BLUETOOTH, SOCK_STREAM, BTPROTO_RFCOMM);
		err  = errno;
	} while(sock == -1 && err == ENFILE);

	assert(sock != -1);
	return sock;
}

int get_connected_sock(int channel) {
	char dest[18];
	get_dev(dest);
	printf("%s\n", dest);

	int sock;
	int r;
	int err;
	do {
		sock = get_sock();
		struct sockaddr_rc  addr;
		memset(&addr, 0, sizeof(addr));

		addr.rc_family = AF_BLUETOOTH;
		addr.rc_channel = channel;
		str2ba(dest, &addr.rc_bdaddr);

		r = connect(sock, (struct sockaddr *)&addr, sizeof(addr));
		err = errno;
		if(r != 0) {
			perror("connect: ");
			fprintf(stderr, "errno = %d\n", err);
			int a = close(sock);
			assert(a == 0);
			usleep(10);
		}
	} while(r != 0 && err == EBUSY);

	assert(r == 0);
	return sock;
}

GwObex *setup(void) {
	int channel = 4;

	int sock = get_connected_sock(channel);

	gint error;
	GwObex *gwo = gw_obex_setup_fd(sock, NULL, 0, NULL, &error);
	assert(gwo != NULL);
	return gwo;
}
