/* GnomerMind - A MasterMind(R)-based game for Gnome
 * (C) 2001 Germano Rizzo
 *
 * cache.h - header file
 * Author: Germano Rizzo
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef CACHE_H
#define CACHE_H

/*
 * theme cache 
 */

#define PIX  27
#define BIT  8

struct theme_cache
{
  GdkPixmap *pix[PIX];
  GdkBitmap *bit[BIT];
  gint base;
  gint ext;
  gchar *about;
};

/*
 * indexes for the various items
 */

#define TILE  0
#define TOK   1
#define PIN  12
#define STT  15
#define U    19
#define B    20
#define L    21
#define R    22
#define UL   23
#define UR   24
#define BL   25
#define BR   26

#define MTOK  0
#define MSTT  1
#define MPIN  2

#ifdef HAVE_ESD

/*
 * sound cache
 */

#define WAV     6

struct sound_cache
{
  gint connection;
  gint sample[WAV];
};

#define PICK    0
#define PUT     1
#define GUESS   2
#define SUCCESS 3
#define FAIL    4
#define RESET   5

#endif

/*
 * "shared" items
 */

const gchar *pix_base_name[PIX];
const gchar *bit_base_name[BIT];

extern struct theme_cache stock;

extern void theme_cache_load ();
extern void theme_cache_free ();

#ifdef HAVE_ESD
const gchar *wav_base_name[WAV];

extern struct sound_cache sndstock;

extern void sound_cache_load ();
#endif

#endif
