// -*- c++ -*-

//  Gnomoradio - gnomoradio/playlist-settings.h
//  Copyright (C) 2004  Matt Gerginski
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef __PLAYLIST_SETTINGS_H
#define __PLAYLIST_SETTINGS_H

#include <gtkmm.h>
#include "criteria-creator.h"
#include "wraporadio/wraporadio.h"

namespace Gnomoradio
{
	class PlaylistSettingsBox : public Gtk::Window
	{
	public:
		PlaylistSettingsBox (Wraporadio::SongList &songlist);
		virtual ~PlaylistSettingsBox ();
		
	protected:
		bool modified;

		Wraporadio::SongList box_songlist;
		Wraporadio::SongList::SongListType type;

		Gtk::Button ok_button;

		Gtk::Entry name_entry;

		Gtk::SpinButton spin_button;

		CriteriaCreator crit_creator;
		
		void add_criteria_input () { crit_creator.add_new_input(); }

		void on_hide_signal () { delete this; }
		void on_ok_clicked ();
		void ok_button_set_sensitive () { ok_button.set_sensitive(); }
		void ok_button_set_insensitive () { ok_button.set_sensitive(false); }
		void set_modified_true () { modified = true; }
        };
}


#endif
