// -*- c++ -*-

//  Gnomoradio - rainbow/http-server.h
//  Copyright (C) 2003  Jim Garrison
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef __RAINBOW_HTTP_SERVER_H
#define __RAINBOW_HTTP_SERVER_H

#include <glibmm.h>
#include <sigc++/sigc++.h>
#include <string>
#include <set>

namespace Rainbow
{
	class HubClient;

	class HttpServer : public sigc::trackable
	{
	public:
		HttpServer (HubClient *hubclient);
		~HttpServer ();

		bool start (unsigned short port = 0);
		void stop ();

	private:
		struct ServerThread : public sigc::trackable
		{
			ServerThread (int _fd, HttpServer *_server)
				: fd(_fd),
				  this_exists(true),
				  server(_server)
				{ dispatch_request_done.connect(sigc::mem_fun(*this, &ServerThread::on_dispatch_done)); }
			int fd;
			Glib::Mutex mutex; // for accessing this_exists
			bool this_exists;
			Glib::Dispatcher dispatch_request_done;
			HttpServer *server;

			void on_dispatch_done ();
		};

		void try_accept ();
		void serve (int fd, const std::string &hostname);
		void serve_thread (ServerThread *th);
		void serve_thread_do (ServerThread *th);
		bool on_sock_event (Glib::IOCondition cond);

		int sock;
		HubClient *hc;

		std::set<ServerThread *> threads;

		friend struct ServerThread;
	};
}

#endif
