//  Gnomoradio - rainbow/init.cc
//  Copyright (C) 2003  Jim Garrison
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include "rainbow/init.h"
#include <csignal>

using namespace Rainbow;
using namespace std;

int Rainbow::Init::refcnt = 0;
HubClient *Rainbow::Init::m_hub = 0;

Rainbow::Init::Init (const Glib::ustring &hubname)
{
	if (refcnt++ == 0) {
		// ignore SIGPIPE
		signal(SIGPIPE, SIG_IGN);

		if (!Glib::thread_supported())
			Glib::thread_init();
		m_hub = new HubClient(hubname);
	}
}

Rainbow::Init::~Init ()
{
	if (--refcnt == 0) {
		delete m_hub;
		m_hub = 0;
	}
}

