// -*- c++ -*-

//  Gnomoradio - roboradio/recommendation.h
//  Copyright (C) 2003  Jim Garrison
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef __ROBORADIO_RECOMMENDATION_H
#define __ROBORADIO_RECOMMENDATION_H

#include <glibmm.h>

#include "rainbow/http-client.h"
#include "roboradio/song.h"

namespace Roboradio
{
	class State;

	class Recommendation : public sigc::trackable
	{
	public:
		Recommendation (const Glib::ustring &uid = Glib::ustring(),
				bool dont_fetch = false);
		~Recommendation ();

		SongRef get_next ();

		sigc::signal<void> signal_new_recommendations;

	private:
		void fetch_recommendations_if_necessary ();
		void fetch_recommendations ();
		void on_recommendations_fetched (bool success);
		void parse_recommendations ();

		Glib::ustring user_id;
		std::deque<SongRef> rec_songs;

		Rainbow::HttpClient *http;

		friend class State;
	};
}

#endif
