// -*- c++ -*-

//  Gnomoradio - roboradio/song-list-radio.h
//  Copyright (C) 2003  Jim Garrison
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version)
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef __ROBORADIO_SONG_LIST_RADIO_H
#define __ROBORADIO_SONG_LIST_RADIO_H

#include "roboradio/song-list.h"

namespace Roboradio
{
	class SongListRadio : public SongListMutable
	{
	public:
		SongListRadio (const ref_ptr<SongList> &sl,
			       Glib::ustring name = Glib::ustring(),
			       unsigned short percent_recommend = 0,
			       bool stock = true);
		virtual ~SongListRadio ();

		ref_ptr<SongList> get_source () const { return source; }

		unsigned short get_percent_recommend () const { return percent_recommend; }
		void set_percent_recommend (unsigned short pr);

		sigc::signal<void,unsigned short> signal_percent_recommend_changed;

	protected:
		Time calculate_remaining_time () const;

		void on_active_song_change ();
		void on_song_removed (iterator s);
		void restock ();

	private:
		ref_ptr<SongList> source;
		unsigned short percent_recommend;
	};
}

#endif
