/**
 ** mp3list_add.c - adding mp3s to the global mp3list
 **
 ** Copyright (C) 2000 Matthew Pratt <mattpratt@yahoo.com>
 **
 ** This software is licensed under the terms of the GNU General 
 ** Public License (GPL). Please see the file LICENSE for details.
 **/ 

#include "mp3list.h"
#include "utility.h"
#include "song_find.h"
#include "song_list.h"
#include "all_list.h"
#include "dir_list.h"
#include "mp3_control.h"

GList *candidates;

/* 
 * adds list of filename to the mp3list if they are not already there 
 */
void mp3list_commit_candidates(int start, int length)
{
    GList *list_ptr = mp3list;
    GList *c_ptr = candidates;
    GList *start_of_search;
    MP3 *mp3;
    int i = 1;

    while(c_ptr){
	start_of_search = list_ptr;
	list_ptr = mp3list_search(list_ptr, c_ptr->data);
	if( !list_ptr ){
	    /* add the mp3 to the lists */
	    mp3 = mp3list_build_entry(c_ptr->data);
	    mp3list = g_list_append( mp3list, mp3 );
	    all_list_add_row(mp3);
	    song_list_add_row(mp3);

	    list_ptr = start_of_search;
	}else{
	    MP3_NODE(list_ptr)->playing = 0; 
	}

	if( (i % 4) == 0 ){
	    gnome_appbar_set_progress (GNOME_APPBAR(GNOME_APP(gnomp3.gnomp3)->statusbar),
				       (float)(start + i++) / (float)length);

	    while(gtk_events_pending())
		gtk_main_iteration();
	}

	c_ptr = c_ptr->next;
    }

    for(c_ptr = candidates; c_ptr; c_ptr = c_ptr->next)
	g_free(c_ptr->data);
    g_list_free(candidates);
    candidates = NULL;

    gnome_appbar_set_progress (GNOME_APPBAR(GNOME_APP(gnomp3.gnomp3)->statusbar),
			       0.0);
}

/*
 * Attempts to add all the mp3 filenames listed in file.
 */
void mp3list_add_candidates_from_file(char *song_list_file)
{
    FILE *fp;
    char line[1024];

    fp = fopen( song_list_file, "r" );
    if( !fp ){
	return;
    }
    
    while( fgets( line, 1024, fp ) ){
	g_strstrip( line );
	candidates = g_list_append( candidates, g_strdup(line));
    }
    fclose(fp);
}

/*
 * Adds mp3 files found in the gnomp3.add_song_dir (additional song dir)
 */
void mp3list_add_dir_songs()
{
    char command[MAX_PATH *2];

    g_snprintf( command, sizeof(command), 
		"ls -1 %s/*.mp3 >%s/.gnomp3/.dir_list", gnomp3.add_song_dir,
		getenv("HOME"));
    system(command);
    mp3list_add_candidates_from_file( file_in_home(".gnomp3/.dir_list"));
}

/* 
 * determines whether the song lists needs to be dynamically generated or
 * simply loaded from disk then loads it 
 */
void mp3list_add_songs()
{
    char *file = file_in_home(".gnomp3/.song_list");
    if( gnomp3.song_search ){
	/* need to generate the list ourselves using find */
	if( !file_exists(file))
	    song_find_load_dialog(file);
	else
	    mp3list_add_candidates_from_file (file);
    }else{
	mp3list_add_candidates_from_file (gnomp3.song_list_file);
    }
    mp3list_add_dir_songs();
}

void mp3list_initial_load()
{
    FILE *fp;
    char filename[255];
    char line[1024];
    int lines = 0, i = 0;
    char **tokens;
    MP3 *new;

    /* first thing we must do is calculate how many songs we are gonna add in total*/
    g_snprintf( filename, sizeof(filename), "%s/.gnomp3/.song_cache", 
		getenv("HOME") );
    fp = fopen(filename, "r");
    if(0){
	while(fgets(line, sizeof(line), fp))
	    lines++;
	rewind(fp);
    }

    mp3list_add_songs();

    /* display how many songs */
    lines = 2 * g_list_length(candidates);
    g_snprintf( line, 1024, "Adding %d songs to song list", lines );
    gnome_appbar_push (GNOME_APPBAR(GNOME_APP(gnomp3.gnomp3)->statusbar),line);
 
    gtk_clist_freeze( GTK_CLIST(gnomp3.all_clist) );
    gtk_clist_freeze( GTK_CLIST(gnomp3.song_ctree) );
    
    /* load songs from cache first */
    while( fp && fgets( line, sizeof(line), fp ) ){
     	tokens = g_strsplit( line, "\t", 20 );
 	new = mp3list_build_full_entry( tokens );
	mp3list = g_list_append( mp3list, new );
	all_list_add_row(new);
	song_list_add_row(new);

	if((i % 20) == 0){
	    gnome_appbar_set_progress (GNOME_APPBAR(GNOME_APP(gnomp3.gnomp3)->statusbar),
				       (float)(i) / (float)lines);
	    while(gtk_events_pending())
		gtk_main_iteration();
	}
	i++;
    }

    /* try to add new songs */
    mp3list_commit_candidates(i, lines);

    gtk_clist_thaw( GTK_CLIST(gnomp3.all_clist) );
    gtk_clist_thaw( GTK_CLIST(gnomp3.song_ctree) );

    if(fp)fclose(fp);

    gnome_appbar_pop (GNOME_APPBAR(GNOME_APP(gnomp3.gnomp3)->statusbar));

    dir_list_build();
}

void mp3list_reload()
{
    GList *ptr;

    unlink(file_in_home(".gnomp3/.song_list"));
    mp3list_add_songs();

    mp3_control_stop();

    for(ptr = mp3list ;ptr; ptr = ptr->next)
	MP3_NODE(ptr)->playing = 1;

    mp3list_commit_candidates(0, g_list_length(candidates));

    for(ptr = mp3list ;ptr; ptr = ptr->next)
	if(MP3_NODE(ptr)->playing == 1)
	    printf("Song to be removed: %s\n", MP3_NODE(ptr)->filename);

    dir_list_build();
}


