/**
 ** preferences.c - preference dialog box
 **
 ** Copyright (C) 2000 Matthew Pratt <mattpratt@yahoo.com>
 **
 ** This software is licensed under the terms of the GNU General 
 ** Public License (GPL). Please see the file LICENSE for details.
 **
 **/

#include "gnomp3.h"
#include "utility.h"
#include "all_list.h"
#include "mp3_control.h"
#include "config.h"

int     prefs_lists_need_reload;

void preferences_load_widgets(GladeXML *xml)
{
    int i;
    struct _config *cp = config_params;
    GdkColor *col;

    for(i = 0; cp[i].value_ptr; i++){
	cp[i].w = glade_xml_get_widget(xml, cp[i].name);
	if(!cp[i].w){printf("No widget named: %s\n", cp[i].name);continue;}
	switch(cp[i].type)
	    {
	    case C_SPIN:
		gtk_spin_button_set_value( GTK_SPIN_BUTTON(cp[i].w), 
					   DEREF(int, cp[i]) );
		break;
	    case C_CHECK:
		gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON (cp[i].w),
					      DEREF(int, cp[i]) );
		break;
	    case C_PATH:
		gtk_entry_set_text( GTK_ENTRY(cp[i].w), (char *)cp[i].value_ptr);
		break;
	    case C_COLOR:
		col = (GdkColor *)cp[i].value_ptr;
		gnome_color_picker_set_i16( GNOME_COLOR_PICKER(cp[i].w), 
					    col->red, 
					    col->green, 
					    col->blue, 0);
		break;
	    }
    }
}

void preferences_load_dialog()
{
    GladeXML *xml;
    
    /* load the main_window decsription */
    xml = glade_xml_new( gnomp3.glade_file, "gnomp3_preferences");
    /* in case we can't load the interface, bail */
    if(!xml) {
	g_warning("We could not load the main_window interface!");
	return;
    }
    
    gnomp3.gnomp3_preferences = glade_xml_get_widget(xml, "gnomp3_preferences");

    preferences_load_widgets(xml);

    /* autoconnect any signals */
    glade_xml_signal_autoconnect(xml);
    
    /* we don't need the GladeXML object any more, so unref it
       to save some memory */
    gtk_object_unref(GTK_OBJECT(xml));
}

void preferences_changed()
{
    gnome_property_box_changed (GNOME_PROPERTY_BOX(gnomp3.gnomp3_preferences));
}

void preferences_lists_need_reload()
{
    prefs_lists_need_reload = TRUE;
}

void preferences_apply(GnomePropertyBox *box, int page_num, gpointer data)
{
    int i;
    struct _config *cp = config_params;
    GdkColor *col;

    for(i = 0; cp[i].value_ptr; i++){
	if(!cp[i].w)continue;
	switch(cp[i].type)
	    {
	    case C_SPIN:
		DEREF(int, cp[i]) = gtk_spin_button_get_value_as_int( 
		    GTK_SPIN_BUTTON(cp[i].w));
		break;
	    case C_CHECK:
		DEREF(int, cp[i]) = GTK_TOGGLE_BUTTON(cp[i].w)->active;
		break;
	    case C_PATH:
		strncpy( (char *)cp[i].value_ptr, 
			 gtk_entry_get_text( GTK_ENTRY(cp[i].w)), MAX_PATH);
		break;
	    case C_COLOR:
		col = (GdkColor *)cp[i].value_ptr;
		gnome_color_picker_get_i16( GNOME_COLOR_PICKER(cp[i].w), 
					    &col->red, 
					    &col->green, 
					    &col->blue, NULL);
		break;
	    }
    }

    if(  prefs_lists_need_reload ){
	mp3list_reload();
	prefs_lists_need_reload = FALSE;
    }

    config_save();
}


