/**
 ** rule_list.c - deals with storage and application of rules for generating 
 **               dynamic playlists
 **
 ** Copyright (C) 2000 Matthew Pratt <mattpratt@yahoo.com>
 **
 ** This software is licensed under the terms of the GNU General 
 ** Public License (GPL). Please see the file LICENSE for details.
 **/ 

#include "gnomp3.h"
#include "utility.h"
#include "mp3info.h"
#include "playlist.h"
#include "rule_list.h"
#include "mp3list.h"

/* extracts any rule in the given line and adds them to the global rule list */
void rule_list_load_rule(char *line)
{
    char *ptr;

    ptr = strstr(line, "RULE:" );
    if(!ptr)return;

    gnomp3.rule_list = g_list_append( gnomp3.rule_list, g_strdup(ptr + 5));
}

/* 
 * save all the rules in the list to the playlist file (given by fp). Each 
 * rule is prepended with a '#' to keep playlists compatible with other 
 * software (xmms). 
 */
void rule_list_save_rules(FILE *fp)
{
    GList *ptr = gnomp3.rule_list;

    if(!ptr)
	return;

    fprintf( fp, "# gnomp3 rule list\n");

    while(ptr){
	fprintf( fp, "# RULE:%s\n", (char *)ptr->data);
	ptr = ptr->next;
    }
}

/*
 * Add a song if it is not already in the playlist. Mark it as being from a 
 * rule.
 */
void rule_list_add_song(MP3 *mp3)
{
    if( mp3->row_playlist != -1 ){
	playlist_add_row(mp3);
    }else{
	playlist_add_row(mp3);
	mp3->from_rule = TRUE;
    }
}

/* 
 * applies every rule in the global rule list. All rule generated entries are
 * first removed from the playlist 
 */
void rule_list_apply()
{
    GList *ptr;
    
    gtk_clist_freeze(GTK_CLIST(gnomp3.play_clist));

    playlist_clear_rules();

    for( ptr = gnomp3.rule_list; ptr; ptr = ptr->next){
	mp3list_search_by_name( ptr->data, rule_list_add_song );
    }
    playlist_update_display();

    gtk_clist_thaw(GTK_CLIST(gnomp3.play_clist));
}

/* clear all the entries from the global rule list */
void rule_list_clear()
{
    g_list_foreach( gnomp3.rule_list, (GFunc)g_free, NULL );
    g_list_free (gnomp3.rule_list);
    gnomp3.rule_list = NULL;
}
