/**
 ** search_list.c - callbacks for the song search list 
 **
 ** Copyright (C) 2000 Matthew Pratt <mattpratt@yahoo.com>
 **
 ** This software is licensed under the terms of the GNU General 
 ** Public License (GPL). Please see the file LICENSE for details.
 **/

#include "gnomp3.h"
#include "mp3list.h"

/*
 * Callback for the mp3list search. Given mp3 is added to the search_clist
 * and is colours set approriately
 */
void search_list_add(MP3 *mp3)
{
    char *col[2];
    int n;

    col[0] = mp3->display_name;
    col[1] = mp3list_build_time(mp3);
    n = gtk_clist_append( GTK_CLIST(gnomp3.search_clist), col);
    gtk_clist_set_row_data( GTK_CLIST(gnomp3.search_clist), n, mp3);
    if(mp3->row_playlist >= 0){
	gtk_clist_set_background( GTK_CLIST(gnomp3.search_clist), n,
 				  &gnomp3.in_playlist_bg_color);
	gtk_clist_set_foreground( GTK_CLIST(gnomp3.search_clist), n,
 				  &gnomp3.in_playlist_fg_color);
    }
}

/* 
 * callback for the changed signal of the search entry. 
 * Clears the search list and performs a new search
 */
void search_entry_changed(GtkEditable *editable, gpointer user_data)
{
    char *string;

    string = gtk_entry_get_text(GTK_ENTRY(editable));
    
    gtk_clist_freeze( GTK_CLIST(gnomp3.search_clist));
    gtk_clist_clear( GTK_CLIST(gnomp3.search_clist));
    
    mp3list_search_by_name( string, search_list_add );
    
    gtk_clist_thaw( GTK_CLIST(gnomp3.search_clist));
}

