/* vi:set ts=8 sts=0 sw=8:
 * $Id: clipboard.c,v 1.11 2000/01/19 17:18:30 kahn Exp kahn $
 *
 * Copyright (C) 1998 Andy C. Kahn
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include "main.h"
#ifdef USE_CLIPBOARD
#include "doc.h"
#include "msgbar.h"
#include "clipboard.h"
#include "gnpintl.h"


/*** global function definitions ***/
/*
 * PUBLIC: copy_cb
 *
 * copies text from the text widget into clipboard
 */
void
copy_cb(GtkWidget *widget, gpointer cbdata)
{
	win_t *w = (win_t *)cbdata;
	doc_t *d;

	g_assert(w != NULL);
	d = DOC_CURRENT(w);
	g_assert(d != NULL);
	gtk_editable_copy_clipboard(GTK_EDITABLE(d->data));
	msgbar_printf(w, _("Text copied to clipboard..."));
} /* copy_cb */


/*
 * PUBLIC: cub_cb
 *
 * removes text from the text widget and places into clipboard
 */
void
cut_cb(GtkWidget *widget, gpointer cbdata)
{
	win_t *w = (win_t *)cbdata;
	doc_t *d;

	g_assert(w != NULL);
	d = DOC_CURRENT(w);
	g_assert(d != NULL);
	gtk_editable_cut_clipboard(GTK_EDITABLE(d->data));
	msgbar_printf(w, _("Text cut to clipboard..."));
} /* cut_cb */


/*
 * PUBLIC: paste_cb
 *
 * pastes clipboard contents into text widget
 */
void
paste_cb(GtkWidget *widget, gpointer cbdata)
{
	win_t *w = (win_t *)cbdata;
	doc_t *d;

	g_assert(w != NULL);
	d = DOC_CURRENT(w);
	g_assert(d != NULL);
	gtk_editable_paste_clipboard(GTK_EDITABLE(d->data));
	msgbar_printf(w, _("Text pasted from clipboard..."));
} /* paste_cb */


/*
 * PUBLIC: selall_cb
 *
 * selects the entire contents of the text widget
 */
void
selall_cb(GtkWidget *widget, gpointer cbdata)
{
	win_t *w = (win_t *)cbdata;
	doc_t *d;

	g_assert(w != NULL);
	d = DOC_CURRENT(w);
	g_assert(d != NULL);
	gtk_editable_select_region(GTK_EDITABLE(d->data), 0,
		gtk_text_get_length(GTK_TEXT(d->data)));
	msgbar_printf(w, _("All text selected..."));
} /* selall_cb */

#endif	/* USE_CLIPBOARD */

/* the end */
