/* vi:set ts=8 sts=0 sw=8:
 * $Id: menu.h,v 1.12 2000/04/14 02:45:17 kahn Exp kahn $
 *
 * Copyright (C) 1998 Andy C. Kahn
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef __MENU_H__
#define __MENU_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#include <gtk/gtk.h>
#include <glib.h>
#include "win.h"

extern void	menu_main_init(win_t *w);
extern void	quickmenu_init(win_t *w);
extern void	quickmenu_show(GtkWidget *wgt, GdkEvent *ev);
#ifdef USE_RECENT
extern void	menu_recent_doc_add(GtkMenuCallback cbf, gpointer cbd);
extern void	menu_recent_doc_remove(gpointer dnnp);
#endif	/* USE_RECENT */
#ifdef GTK_HAVE_FEATURES_1_1_0
extern void	menu_main_state_set(void *data);
#else
# define	menu_main_state_set(data)
#endif

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif
