/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * GnoWavCut -- a GNOME/GTK+ based RIFF PCM Wave file splitter
 * Copyright (C) 2000 Yoichi Imai <yoichi@silver-forest.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#include "config.h"

#include <gnome.h>
#include <limits.h>

#include "main.h"
#include "file.h"
#include "about.h"
#include "wave.h"
#include "utils.h"
#include "timelist.h"
#include "split.h"
#include "listfile.h"
#include "prefs.h"
#include "prefs_dialog.h"

struct poptOption popt_options[] = {
	{NULL, '\0', 0, NULL, 0}
};

static void app_will_exit(GtkWidget *widget, gpointer data);
static void about_open_cb(GtkWidget *widget, gpointer data);
static gint hadj_value_change_cb(GtkWidget *widget, gpointer data);
static void hscale_press_cb(GtkWidget *widget, GdkEventButton *event, gpointer data);
static void hscale_release_cb(GtkWidget *widget, GdkEventButton *event, gpointer data);
static void hscale_press_cb(GtkWidget *widget, GdkEventButton *event, gpointer data)
{
	GnoWavCut *gnowavcut;
	
	gnowavcut = (GnoWavCut *)data;
	
	gnowavcut->hscale_can_move = FALSE;
}
static void hscale_release_cb(GtkWidget *widget, GdkEventButton *event, gpointer data)
{
	GnoWavCut *gnowavcut;
	
	gnowavcut = (GnoWavCut *)data;
	
	wave_jump_using_hscale(gnowavcut);
	
	gnowavcut->hscale_can_move = TRUE;
	
}
static gint hadj_value_change_cb(GtkWidget *widget, gpointer data)
{
	GnoWavCut *gnowavcut;
	WaveInfo *wave_info;
	gfloat value;
	int sec;
	gchar *time;
	
	gnowavcut = (GnoWavCut *)data;
	wave_info = gnowavcut->wave_info;

	if (gnowavcut->hscale_can_move == FALSE) {
		value = GTK_ADJUSTMENT(gnowavcut->hadj)->value;

		sec = (gint) (wave_info->data_size * (value / 100) / wave_info->size_per_sec);

		time = utils_get_time_from_seconds(sec);
		gtk_label_set_text(GTK_LABEL(gnowavcut->label_middle), time);
    
		g_free(time);
	}

	return TRUE;
}

static void app_will_exit(GtkWidget *widget, gpointer data)
{
	GtkWidget *msgbox;
	GnoWavCut *gnowavcut;
	gint ret_val;

	gnowavcut = (GnoWavCut *)data;

	msgbox = gnome_message_box_new(_("Are you sure you want to exit?"),
				       GNOME_MESSAGE_BOX_QUESTION,
				       GNOME_STOCK_BUTTON_YES,
				       GNOME_STOCK_BUTTON_NO,
				       NULL);
	gnome_dialog_set_default(GNOME_DIALOG(msgbox), 1);
	ret_val = gnome_dialog_run_and_close(GNOME_DIALOG(msgbox));
	if (ret_val == 0) {
		if (gnowavcut->now_playing == TRUE) {
			utils_gnowavcut_if_playing(gnowavcut, FALSE);
		}
		prefs_save();
		gtk_main_quit();
	}
}
static void about_open_cb(GtkWidget *widget, gpointer data)
{
	about_open();
}

static GnomeUIInfo file_menu[] = {
	GNOMEUIINFO_MENU_OPEN_ITEM(file_dialog_open_cb, NULL),
	GNOMEUIINFO_SEPARATOR,
	GNOMEUIINFO_ITEM_STOCK(N_("Open List File"),
			       N_("Open List File"),
			       listfile_open_cb,
			       GNOME_STOCK_MENU_OPEN),
	GNOMEUIINFO_ITEM_STOCK(N_("Save List File"),
			       N_("Save List File"),
			       listfile_save_cb,
			       GNOME_STOCK_MENU_SAVE),
	GNOMEUIINFO_SEPARATOR,
	GNOMEUIINFO_MENU_EXIT_ITEM(app_will_exit, NULL),
	GNOMEUIINFO_END
};

static GnomeUIInfo edit_menu[] = {
	GNOMEUIINFO_ITEM(N_("Start to split"),
			 N_("Start to split opened wave file"),
			 split_start_cb, NULL),
	GNOMEUIINFO_ITEM(N_("Start to split with filtering"),
			 N_("Start to split opened wave file with filtering program"),
			 split_start_with_filtering_cb, NULL),
	GNOMEUIINFO_END
};
static GnomeUIInfo settings_menu[] = {
	GNOMEUIINFO_MENU_PREFERENCES_ITEM(prefs_dialog_open_cb, NULL),
	GNOMEUIINFO_END
};

static GnomeUIInfo help_menu[] = {
	/*	GNOMEUIINFO_HELP(PACKAGE), */
	GNOMEUIINFO_MENU_ABOUT_ITEM(about_open_cb, NULL),
	GNOMEUIINFO_END
};

static GnomeUIInfo main_menu[] = {
	GNOMEUIINFO_MENU_FILE_TREE(file_menu),
	GNOMEUIINFO_MENU_EDIT_TREE(edit_menu),
	GNOMEUIINFO_MENU_SETTINGS_TREE(settings_menu),
	GNOMEUIINFO_MENU_HELP_TREE(help_menu),
	GNOMEUIINFO_END
};

static char *clist_titles[] = {
	N_("Start"), N_("End")
};

int
main(int argc, char *argv[])
{
	GtkWidget *app;
	GtkWidget *appbar;

	GtkWidget *vbox;

	GtkWidget *frame_info;
	GtkWidget *frame_output;

	GtkWidget *vbox_info;
	GtkWidget *entry_file;
	GtkObject *volume_adj;
	GtkWidget *progress;
	GtkWidget *label_middle;
	GtkWidget *label_end;
	GtkWidget *entry_rate;
	GtkWidget *entry_bit;
	GtkWidget *entry_channel;
	GtkWidget *vsep;

	GtkWidget *hscale;
	GtkObject *hadj;
	GtkWidget *button_rew;
	GtkWidget *button_stop;
	GtkWidget *button_pause;
	GtkWidget *button_play;
	GtkWidget *button_ff;

	GtkWidget *frame_mini;
	GtkWidget *b_mini_rew_long;
	GtkWidget *b_mini_rew;
	GtkWidget *b_mini_insert;
	GtkWidget *label_mini;
	GtkWidget *b_mini_play;
	GtkWidget *b_mini_ff;
	GtkWidget *b_mini_ff_long;
  
	GtkWidget *vbox_output;
	GtkWidget *entry_base;
	GtkWidget *fentry_dir;
	GtkWidget *clist;

	GtkWidget *vbox10;
	GtkWidget *entry_start;
	GtkWidget *entry_end;

	GtkWidget *vbox_b;
	GtkWidget *button_from;
	GtkWidget *button_end;
	GtkWidget *button_append;
	GtkWidget *button_delete;
	GtkWidget *button_initialize;

	GtkWidget *hbox1;
	GtkWidget *hbox2;
	GtkWidget *hbox3;
	GtkWidget *hbox4;
	GtkWidget *hbox5;
	GtkWidget *hbox6;
	GtkWidget *hbox7;
	GtkWidget *hbox8;
	GtkWidget *hbox9;

	GtkWidget *scwin;

	GtkWidget *label;
	GnoWavCut *gnowavcut;

	poptContext ctx;
	const gchar *arg_filename;

	/*	g_thread_init(NULL);
	if (!g_thread_supported()) {
		g_error(_("Threads isn't supported on your platform. \n"
			  "You need to recompile GNOME after installed LinuxThreads.\n"));
		exit(1);
	}
	*/

	gnome_init_with_popt_table(PACKAGE, VERSION, argc, argv, popt_options, 0, &ctx);
	
	bindtextdomain(PACKAGE, GNOMELOCALEDIR);
	textdomain(PACKAGE);

	gnowavcut = g_new0(GnoWavCut, 1);
	gnowavcut->wave_info = g_new0(WaveInfo, 1);
	gnowavcut->buttons = g_new0(Buttons, 1);
	gnowavcut->file_name = NULL;
	gnowavcut->dsp_fd = -1;
	gnowavcut->wave_fd = -1;
	gnowavcut->input_tag = -1;
	gnowavcut->mini_play_size = 0;

 	app = gnome_app_new(PACKAGE, "GnoWavCut");
	gtk_signal_connect(GTK_OBJECT(app), "delete_event",
			   GTK_SIGNAL_FUNC(app_will_exit),
			   NULL);

	prefs_load();
	gnome_app_create_menus_with_data(GNOME_APP(app), main_menu, gnowavcut);

	appbar = gnome_appbar_new(FALSE, TRUE, GNOME_PREFERENCES_USER);
	gnome_app_set_statusbar(GNOME_APP(app), appbar);

	gnome_app_install_menu_hints(GNOME_APP(app), main_menu);

	vbox = gtk_vbox_new(FALSE, 0);
	gnome_app_set_contents(GNOME_APP(app), vbox);

	frame_info = gtk_frame_new(_("Info"));
	gtk_box_pack_start(GTK_BOX(vbox), frame_info, FALSE, FALSE, 0);

	vbox_info = gtk_vbox_new(FALSE, 0);
	gtk_container_add(GTK_CONTAINER(frame_info), vbox_info);

	hbox1 = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(vbox_info), hbox1, FALSE, FALSE, 0);

	label = gtk_label_new(_("File:"));
	gtk_box_pack_start(GTK_BOX(hbox1), label, FALSE, FALSE, 0);

	entry_file = gtk_entry_new();
	gtk_entry_set_editable(GTK_ENTRY(entry_file), FALSE);
	gtk_box_pack_start(GTK_BOX(hbox1), entry_file, TRUE, TRUE, 0);

	volume_adj = gtk_adjustment_new(0.0, 0.0, (double) SHRT_MAX, 0.1, 0.1, 0.1);
	progress = gtk_progress_bar_new_with_adjustment(GTK_ADJUSTMENT(volume_adj));
	gtk_box_pack_start(GTK_BOX(vbox_info), progress, FALSE, FALSE, 0);

	hbox2 = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(vbox_info), hbox2, FALSE, FALSE, 0);

	label_middle = gtk_label_new("000:00");
	gtk_box_pack_start(GTK_BOX(hbox2), label_middle, FALSE, FALSE, 0);
	gtk_widget_set_usize (label_middle, 50, -2);

	label = gtk_label_new("/");
	gtk_box_pack_start(GTK_BOX(hbox2), label, FALSE, FALSE, 0);
  
	label_end = gtk_label_new("000:00");
	gtk_box_pack_start(GTK_BOX(hbox2), label_end, FALSE, FALSE, 0);
	gtk_widget_set_usize (label_end, 50, -2);

	entry_channel = gtk_entry_new();
	gtk_entry_set_editable(GTK_ENTRY(entry_channel), FALSE);
	gtk_box_pack_end(GTK_BOX(hbox2), entry_channel, FALSE, FALSE, 0);
	gtk_widget_set_usize (entry_channel, 60, -2);
  
	label = gtk_label_new(_("bit"));
	gtk_box_pack_end(GTK_BOX(hbox2), label, FALSE, FALSE, 0);

	entry_bit = gtk_entry_new();
	gtk_entry_set_editable(GTK_ENTRY(entry_bit), FALSE);
	gtk_box_pack_end(GTK_BOX(hbox2), entry_bit, FALSE, FALSE, 0);
	gtk_widget_set_usize (entry_bit, 25, -2);

	label = gtk_label_new(_("Hz"));
	gtk_box_pack_end(GTK_BOX(hbox2), label, FALSE, FALSE, 0);
  
	entry_rate = gtk_entry_new();
	gtk_entry_set_editable(GTK_ENTRY(entry_rate), FALSE);
	gtk_box_pack_end(GTK_BOX(hbox2), entry_rate, FALSE, FALSE, 0);
	gtk_widget_set_usize (entry_rate, 50, -2);

	vsep = gtk_vseparator_new();
	gtk_box_pack_end(GTK_BOX(hbox2), vsep, FALSE, FALSE, 0);
	gtk_widget_set_usize (vsep, 20, -2);


	hadj = gtk_adjustment_new(0.0, 0.0, 100.0, 0.2, 1.0, 1.0);
	gtk_signal_connect(GTK_OBJECT(hadj), "value_changed",
			   GTK_SIGNAL_FUNC(hadj_value_change_cb),
			   gnowavcut);

	hscale = gtk_hscale_new (GTK_ADJUSTMENT(hadj));
	gtk_scale_set_digits (GTK_SCALE (hscale), 1);
	gtk_range_set_update_policy (GTK_RANGE (hscale), GTK_UPDATE_CONTINUOUS);
	gtk_scale_set_draw_value (GTK_SCALE (hscale), FALSE);
	gtk_box_pack_start(GTK_BOX(vbox), hscale, FALSE, FALSE, 0);
	gtk_signal_connect(GTK_OBJECT(hscale), "button_press_event",
			   GTK_SIGNAL_FUNC(hscale_press_cb),
			   gnowavcut);
	gtk_signal_connect(GTK_OBJECT(hscale), "button_release_event",
			   GTK_SIGNAL_FUNC(hscale_release_cb),
			   gnowavcut);

	hbox3 = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(vbox), hbox3, FALSE, FALSE, 0);
	gtk_widget_set_usize(hbox3, -2, 40);
  
	button_rew = gtk_button_new_with_label(_("<<"));
	gtk_box_pack_start(GTK_BOX(hbox3), button_rew, FALSE, FALSE, 0);
	gtk_widget_set_usize(button_rew, 40, -2);
	gtk_signal_connect(GTK_OBJECT(button_rew), "clicked",
			   GTK_SIGNAL_FUNC(wave_rew_cb), gnowavcut);

	button_stop = gtk_button_new_with_label(_("Stop"));
	gtk_box_pack_start(GTK_BOX(hbox3), button_stop, FALSE, FALSE, 0);  
	gtk_widget_set_usize(button_stop, 40, -2);
	gtk_signal_connect(GTK_OBJECT(button_stop), "clicked",
			   GTK_SIGNAL_FUNC(wave_stop_cb), gnowavcut);

	button_pause = gtk_button_new_with_label(_("||"));
	gtk_box_pack_start(GTK_BOX(hbox3), button_pause, FALSE, FALSE, 0);
	gtk_widget_set_usize(button_pause, 40, -2);
	gtk_signal_connect(GTK_OBJECT(button_pause), "clicked",
			   GTK_SIGNAL_FUNC(wave_pause_cb), gnowavcut);

	button_play = gtk_button_new_with_label(_("Play"));
	gtk_box_pack_start(GTK_BOX(hbox3), button_play, FALSE, FALSE, 0);  
	gtk_widget_set_usize(button_play, 40, -2);
	gtk_signal_connect(GTK_OBJECT(button_play), "clicked",
			   GTK_SIGNAL_FUNC(wave_play_cb), gnowavcut);

	button_ff = gtk_button_new_with_label(_(">>"));
	gtk_box_pack_start(GTK_BOX(hbox3), button_ff, FALSE, FALSE, 0);
	gtk_widget_set_usize(button_ff, 40, -2);
	gtk_signal_connect(GTK_OBJECT(button_ff), "clicked",
			   GTK_SIGNAL_FUNC(wave_ff_cb), gnowavcut);

	frame_mini = gtk_frame_new(_("Mini Control"));
	gtk_box_pack_start(GTK_BOX(hbox3), frame_mini, TRUE, TRUE, 0);

	hbox4 = gtk_hbox_new(FALSE, 0);
	gtk_container_add(GTK_CONTAINER(frame_mini), hbox4);

	b_mini_rew_long = gtk_button_new_with_label(_("<<"));
	gtk_box_pack_start(GTK_BOX(hbox4), b_mini_rew_long, TRUE, TRUE, 0);
	gtk_signal_connect(GTK_OBJECT(b_mini_rew_long), "clicked",
			   GTK_SIGNAL_FUNC(wave_rew_mini_long_cb), gnowavcut);
	b_mini_rew = gtk_button_new_with_label(_("<"));
	gtk_box_pack_start(GTK_BOX(hbox4), b_mini_rew, TRUE, TRUE, 0);
	gtk_signal_connect(GTK_OBJECT(b_mini_rew), "clicked",
			   GTK_SIGNAL_FUNC(wave_rew_mini_cb), gnowavcut);

	b_mini_insert = gtk_button_new_with_label(_("Insert"));
	gtk_box_pack_start(GTK_BOX(hbox4), b_mini_insert, TRUE, TRUE, 0);
	gtk_signal_connect(GTK_OBJECT(b_mini_insert), "clicked",
			   GTK_SIGNAL_FUNC(timelist_insert_cb), gnowavcut);

	label_mini = gtk_label_new("          ");
	gtk_box_pack_start(GTK_BOX(hbox4), label_mini, TRUE, TRUE, 0);
	gtk_widget_set_usize(label_mini, 60, -2);

	b_mini_play = gtk_button_new_with_label(_("Play"));
	gtk_box_pack_start(GTK_BOX(hbox4), b_mini_play, TRUE, TRUE, 0);
	gtk_signal_connect(GTK_OBJECT(b_mini_play), "clicked",
			   GTK_SIGNAL_FUNC(wave_play_mini_cb), gnowavcut);

	b_mini_ff = gtk_button_new_with_label(_(">"));
	gtk_box_pack_start(GTK_BOX(hbox4), b_mini_ff, TRUE, TRUE, 0);
	gtk_signal_connect(GTK_OBJECT(b_mini_ff), "clicked",
			   GTK_SIGNAL_FUNC(wave_ff_mini_cb), gnowavcut);
	b_mini_ff_long = gtk_button_new_with_label(_(">>"));
	gtk_box_pack_start(GTK_BOX(hbox4), b_mini_ff_long, TRUE, TRUE, 0);
	gtk_signal_connect(GTK_OBJECT(b_mini_ff_long), "clicked",
			   GTK_SIGNAL_FUNC(wave_ff_mini_long_cb), gnowavcut);  
  
	frame_output = gtk_frame_new(_("Output"));
	gtk_box_pack_start(GTK_BOX(vbox), frame_output, TRUE, TRUE, 0);

	vbox_output = gtk_vbox_new(FALSE, 0);
	gtk_container_add(GTK_CONTAINER(frame_output), vbox_output);

	hbox5 = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(vbox_output), hbox5, FALSE, FALSE, 0);
  
	label = gtk_label_new(_("Base name:"));
	gtk_box_pack_start(GTK_BOX(hbox5), label, FALSE, FALSE, 0);

	entry_base = gtk_entry_new();
	gtk_box_pack_start(GTK_BOX(hbox5), entry_base, FALSE, FALSE, 0);
	gtk_widget_set_usize (entry_base, 100, -2);

	hbox6 = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(vbox_output), hbox6, FALSE, FALSE, 0);

	label = gtk_label_new(_("Directory:"));
	gtk_box_pack_start(GTK_BOX(hbox6), label, FALSE, FALSE, 0);
    
	fentry_dir = gnome_file_entry_new("OutputDir", _("Select output directory..."));
	gnome_file_entry_set_directory(GNOME_FILE_ENTRY(fentry_dir), TRUE);
	gtk_box_pack_start(GTK_BOX(hbox6), fentry_dir, TRUE, TRUE, 0);

	hbox7 = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(vbox_output), hbox7, TRUE, TRUE, 0);

	vbox10 = gtk_vbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(hbox7), vbox10, TRUE, TRUE, 0);

	hbox8 = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(vbox10), hbox8, FALSE, FALSE, 0);

	entry_start = gtk_entry_new();
	gtk_box_pack_start(GTK_BOX(hbox8), entry_start, TRUE, TRUE, 0);

	label = gtk_label_new("->");
	gtk_box_pack_start(GTK_BOX(hbox8), label, FALSE, FALSE, 0);

	entry_end = gtk_entry_new();
	gtk_box_pack_start(GTK_BOX(hbox8), entry_end, TRUE, TRUE, 0);
  
	scwin = gtk_scrolled_window_new (NULL, NULL);
	gtk_container_set_border_width (GTK_CONTAINER (scwin), 0);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scwin),
					GTK_POLICY_AUTOMATIC, 
					GTK_POLICY_AUTOMATIC);
	/* gtk_widget_set_usize(scwin, 180, -2); */
	gtk_box_pack_start (GTK_BOX (vbox10), scwin, TRUE, TRUE, 0);

	clist = gtk_clist_new_with_titles(2, clist_titles);
	gtk_clist_set_column_width (GTK_CLIST (clist), 0, 80);
	gtk_clist_set_column_width (GTK_CLIST (clist), 1, 80);
	gtk_container_add (GTK_CONTAINER (scwin), clist);
	gtk_clist_set_selection_mode (GTK_CLIST(clist),GTK_SELECTION_BROWSE);
	gtk_signal_connect(GTK_OBJECT(clist), "button_press_event",
			   GTK_SIGNAL_FUNC(timelist_button_press_cb),
			   gnowavcut);

	vbox_b = gtk_vbox_new(TRUE, 0);
	gtk_box_pack_start(GTK_BOX(hbox7), vbox_b, FALSE, FALSE, 0);

	hbox9 = gtk_hbox_new(TRUE, 0);
	gtk_box_pack_start(GTK_BOX(vbox_b), hbox9, FALSE, FALSE, 0);

	button_from = gtk_button_new_with_label(_("From"));
	gtk_box_pack_start(GTK_BOX(hbox9), button_from, FALSE, FALSE, 0);
	gtk_signal_connect(GTK_OBJECT(button_from), "clicked",
			   GTK_SIGNAL_FUNC(timelist_from_cb), gnowavcut);

	button_end = gtk_button_new_with_label(_("End"));
	gtk_box_pack_start(GTK_BOX(hbox9), button_end, FALSE, FALSE, 0);
	gtk_signal_connect(GTK_OBJECT(button_end), "clicked",
			   GTK_SIGNAL_FUNC(timelist_end_cb), gnowavcut);

	button_append = gtk_button_new_with_label(_("Append"));
	gtk_box_pack_start(GTK_BOX(vbox_b), button_append, FALSE, FALSE, 0);
	gtk_signal_connect(GTK_OBJECT(button_append), "clicked",
			   GTK_SIGNAL_FUNC(timelist_append_cb), gnowavcut);

	button_delete = gtk_button_new_with_label(_("Delete"));
	gtk_box_pack_start(GTK_BOX(vbox_b), button_delete, FALSE, FALSE, 0);
	gtk_signal_connect(GTK_OBJECT(button_delete), "clicked",
			   GTK_SIGNAL_FUNC(timelist_remove_cb), gnowavcut);

	button_initialize = gtk_button_new_with_label(_("Init"));
	gtk_box_pack_start(GTK_BOX(vbox_b), button_initialize, FALSE, FALSE, 0);
	gtk_signal_connect(GTK_OBJECT(button_initialize), "clicked",
			   GTK_SIGNAL_FUNC(timelist_init_cb), gnowavcut);

	gtk_widget_show_all(app);

	gnowavcut->app = app;
	gnowavcut->appbar = appbar;
	gnowavcut->entry_file = entry_file;
	gnowavcut->volume_adj = volume_adj;
	gnowavcut->label_middle = label_middle;
	gnowavcut->label_end = label_end;
	gnowavcut->entry_rate = entry_rate;
	gnowavcut->entry_bit = entry_bit;
	gnowavcut->entry_channel = entry_channel;
	gnowavcut->hscale = hscale;
	gnowavcut->hadj = hadj;
	gnowavcut->entry_base = entry_base;
	gnowavcut->fentry_dir = fentry_dir;
	gnowavcut->clist = clist;
	gnowavcut->label_mini = label_mini;
	gnowavcut->entry_start = entry_start;
	gnowavcut->entry_end = entry_end;

	gnowavcut->buttons->b_mini_rew_long = b_mini_rew_long;
	gnowavcut->buttons->b_mini_rew = b_mini_rew;
	gnowavcut->buttons->b_mini_insert = b_mini_insert;
	gnowavcut->buttons->b_mini_play = b_mini_play;
	gnowavcut->buttons->b_mini_ff = b_mini_ff;
	gnowavcut->buttons->b_mini_ff_long = b_mini_ff_long;

	gnowavcut->buttons->button_rew = button_rew;
	gnowavcut->buttons->button_stop = button_stop;
	gnowavcut->buttons->button_pause = button_pause;
	gnowavcut->buttons->button_play = button_play;
	gnowavcut->buttons->button_ff = button_ff;

	utils_gnowavcut_if_playing(gnowavcut,FALSE);
	gnowavcut->now_pause = FALSE;
	gnowavcut->hscale_can_move = TRUE;

	if((arg_filename = poptGetArg(ctx)) != NULL) {
		gchar *path;
		if(arg_filename[0] == G_DIR_SEPARATOR) 
			path = g_strdup(arg_filename);
		else
			path = g_strconcat(g_get_current_dir(), G_DIR_SEPARATOR_S, arg_filename, NULL);
		
		file_open(gnowavcut, path);
		g_free(path);
	}
	gtk_main();

	return 0;
}

