/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * GnoWavCut -- a GNOME/GTK+ based RIFF PCM Wave file splitter
 * Copyright (C) 2000 Yoichi Imai <yoichi@silver-forest.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#include "config.h"

#include <gnome.h>
#include "prefs_dialog.h"
#include "prefs.h"

#define MODIFIED_SIGNAL_CONNECT(widget, signal, prefs_dialog) \
{ \
 gtk_signal_connect(GTK_OBJECT(widget), signal, \
                    GTK_SIGNAL_FUNC(prefs_dialog_changed_cb), prefs_dialog); \
}

static void prefs_dialog_open(void);
static void prefs_dialog_destroy_cb(GtkWidget *widget, gpointer data);
static GtkWidget *prefs_dialog_create_playing_page(gpointer data);
/* static GtkWidget *prefs_dialog_create_output_page(gpointer data); */
static void prefs_dialog_changed_cb(GtkWidget *widget, gpointer data);
static void prefs_dialog_apply_settings(PrefsDialog *prefs_dialog);
static void prefs_dialog_apply_settings(PrefsDialog *prefs_dialog)
{
	g_free(settings->wave_dsp_dev);
	settings->wave_dsp_dev = g_strdup(gtk_entry_get_text(GTK_ENTRY(prefs_dialog->dsp_dev_entry)));
	settings->wave_mini_play_sec = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(prefs_dialog->mini_play_sec_spin));
	settings->wave_move_sec = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(prefs_dialog->move_sec_spin));
	settings->wave_mini_preview_play = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(prefs_dialog->mini_preview_play_check));
	settings->wave_use_volume_bar = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(prefs_dialog->use_volume_bar_check));

	g_free(settings->suffix);
	settings->suffix = g_strdup(gtk_entry_get_text(GTK_ENTRY(prefs_dialog->suffix_entry)));
	g_free(settings->filter_command);
	settings->filter_command = g_strdup(gtk_entry_get_text(GTK_ENTRY(prefs_dialog->filter_command_entry)));

	prefs_save();

	gtk_widget_set_sensitive(GNOME_PROPERTY_BOX(prefs_dialog->pbox)->ok_button, FALSE);
	gtk_widget_set_sensitive(GNOME_PROPERTY_BOX(prefs_dialog->pbox)->apply_button, FALSE);	
}
static void prefs_dialog_set_settings(PrefsDialog *prefs_dialog)
{
	gtk_entry_set_text(GTK_ENTRY(prefs_dialog->dsp_dev_entry), settings->wave_dsp_dev);
	gtk_spin_button_set_value (GTK_SPIN_BUTTON (prefs_dialog->mini_play_sec_spin), (gfloat) settings->wave_mini_play_sec);
	gtk_spin_button_set_value (GTK_SPIN_BUTTON (prefs_dialog->move_sec_spin), (gfloat) settings->wave_move_sec);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(prefs_dialog->mini_preview_play_check), settings->wave_mini_preview_play);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(prefs_dialog->use_volume_bar_check), settings->wave_use_volume_bar);
	gtk_entry_set_text(GTK_ENTRY(prefs_dialog->suffix_entry), settings->suffix);
	gtk_entry_set_text(GTK_ENTRY(prefs_dialog->filter_command_entry), settings->filter_command);
}

static void prefs_dialog_destroy_cb(GtkWidget *widget, gpointer data)
{
	PrefsDialog *prefs_dialog;

	prefs_dialog = (PrefsDialog *)data;

	g_free(prefs_dialog);
}
static GtkWidget *prefs_dialog_create_filtering_page(gpointer data)
{
	PrefsDialog *prefs_dialog;
	GtkWidget *label;
	GtkWidget *vbox;
	GtkWidget *hbox;
	GtkWidget *hsep;

	prefs_dialog = (PrefsDialog *)data;
	vbox = gtk_vbox_new(FALSE, GNOME_PAD_SMALL);
	gtk_container_set_border_width(GTK_CONTAINER(vbox), GNOME_PAD);

	hbox = gtk_hbox_new(FALSE, GNOME_PAD_SMALL);
	gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 0);
	label = gtk_label_new(_("File suffix after filtering:"));
	gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 0);

	prefs_dialog->suffix_entry = gtk_entry_new();
	gtk_box_pack_start(GTK_BOX(hbox), prefs_dialog->suffix_entry, FALSE, FALSE, 0);
	
	hsep = gtk_hseparator_new();
	gtk_widget_set_usize(hsep, 15, -1);
	gtk_box_pack_start(GTK_BOX(vbox), hsep, FALSE, FALSE, 0);

	label = gtk_label_new(_("Filtering command(%s = output filename)\nlike \"lame -h - %s\".\nGnoWavCut outputs wave data to filtering program's stdin."));
	gtk_box_pack_start(GTK_BOX(vbox), label, FALSE, FALSE, 0);

	prefs_dialog->filter_command_entry = gtk_entry_new();
	gtk_box_pack_start(GTK_BOX(vbox), prefs_dialog->filter_command_entry, FALSE, FALSE, 0);

	MODIFIED_SIGNAL_CONNECT(prefs_dialog->suffix_entry, "changed", prefs_dialog);
	MODIFIED_SIGNAL_CONNECT(prefs_dialog->filter_command_entry, "changed", prefs_dialog);

	return vbox;
}
	
static GtkWidget *prefs_dialog_create_playing_page(gpointer data)
{
	PrefsDialog *prefs_dialog;
	GtkWidget *vbox;
	GtkWidget *hbox;
	GtkWidget *label;
	GtkObject *adj;
	
	prefs_dialog = (PrefsDialog *)data;
	vbox = gtk_vbox_new(FALSE, GNOME_PAD_SMALL);
	gtk_container_set_border_width(GTK_CONTAINER(vbox), GNOME_PAD);

	hbox = gtk_hbox_new(FALSE, GNOME_PAD_SMALL);
	gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 0);
	label = gtk_label_new(_("DSP Device:"));
	gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 0);
	prefs_dialog->dsp_dev_entry = gtk_entry_new();
	gtk_box_pack_start(GTK_BOX(hbox), prefs_dialog->dsp_dev_entry, FALSE, FALSE, 0);

	prefs_dialog->mini_preview_play_check = gtk_check_button_new_with_label(_("Use preview playing when using mini control"));
	gtk_box_pack_start(GTK_BOX(vbox), prefs_dialog->mini_preview_play_check, FALSE, FALSE, 0);

	hbox = gtk_hbox_new(FALSE, GNOME_PAD_SMALL);
	gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 0);
	label = gtk_label_new(_("Length to play by mini control:"));
	gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 0);
	adj = gtk_adjustment_new(0, 0, 20, 1, 1, 1);
	prefs_dialog->mini_play_sec_spin = gtk_spin_button_new (GTK_ADJUSTMENT (adj), 1, 0);
	gtk_spin_button_set_numeric (GTK_SPIN_BUTTON (prefs_dialog->mini_play_sec_spin), TRUE);
	gtk_box_pack_start(GTK_BOX(hbox), prefs_dialog->mini_play_sec_spin, FALSE, FALSE, 0);
	label = gtk_label_new(_("second(s)"));
	gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 0);

	hbox = gtk_hbox_new(FALSE, GNOME_PAD_SMALL);
	gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 0);
	label = gtk_label_new(_("Length to move by FF or rewind:"));
	gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 0);
	adj = gtk_adjustment_new(0, 0, 30, 1, 1, 1);
	prefs_dialog->move_sec_spin = gtk_spin_button_new (GTK_ADJUSTMENT (adj), 1, 0);
	gtk_spin_button_set_numeric (GTK_SPIN_BUTTON (prefs_dialog->move_sec_spin), TRUE);
	gtk_box_pack_start(GTK_BOX(hbox), prefs_dialog->move_sec_spin, FALSE, FALSE, 0);
	label = gtk_label_new(_("second(s)"));
	gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 0);
	
	prefs_dialog->use_volume_bar_check = gtk_check_button_new_with_label(_("Use volume meter (Experimental)"));
	gtk_box_pack_start(GTK_BOX(vbox), prefs_dialog->use_volume_bar_check, FALSE, FALSE, 0);
	
	MODIFIED_SIGNAL_CONNECT(prefs_dialog->dsp_dev_entry, "changed", prefs_dialog);
	MODIFIED_SIGNAL_CONNECT(prefs_dialog->mini_preview_play_check, "toggled", prefs_dialog);
	MODIFIED_SIGNAL_CONNECT(prefs_dialog->mini_play_sec_spin, "changed", prefs_dialog);
	MODIFIED_SIGNAL_CONNECT(prefs_dialog->move_sec_spin, "changed", prefs_dialog);
	MODIFIED_SIGNAL_CONNECT(prefs_dialog->use_volume_bar_check, "toggled", prefs_dialog);

	return vbox;
}
/*
static GtkWidget *prefs_dialog_create_output_page(gpointer data)
{
	PrefsDialog *prefs_dialog;
	GtkWidget *vbox;

	prefs_dialog = (PrefsDialog *)data;

	return vbox;
}
*/

static void prefs_dialog_changed_cb(GtkWidget *widget, gpointer data)
{
	PrefsDialog *prefs_dialog;
	prefs_dialog = (PrefsDialog *)data;

	gtk_widget_set_sensitive(GNOME_PROPERTY_BOX(prefs_dialog->pbox)->ok_button, TRUE);
	gtk_widget_set_sensitive(GNOME_PROPERTY_BOX(prefs_dialog->pbox)->apply_button, TRUE);
}
static void prefs_dialog_ok_cb(GtkWidget *widget, gpointer data)
{
	PrefsDialog *prefs_dialog;
	prefs_dialog = (PrefsDialog *)data;

	prefs_dialog_apply_settings(prefs_dialog);
	gtk_widget_destroy(prefs_dialog->pbox);
}
static void prefs_dialog_apply_cb(GtkWidget *widget, gpointer data)
{
	PrefsDialog *prefs_dialog;
	prefs_dialog = (PrefsDialog *)data;

	prefs_dialog_apply_settings(prefs_dialog);
}

static void prefs_dialog_open(void)
{
	PrefsDialog *prefs_dialog;
	GtkWidget *label;

	prefs_dialog = g_new0(PrefsDialog, 1);
	
	prefs_dialog->pbox = gnome_property_box_new();
	gtk_window_set_title(GTK_WINDOW(prefs_dialog->pbox),
			     _("GnoWavCut - Preferences"));
	gtk_signal_connect(GTK_OBJECT(prefs_dialog->pbox), "destroy",
			   GTK_SIGNAL_FUNC(prefs_dialog_destroy_cb), prefs_dialog);
	gtk_signal_connect(GTK_OBJECT(GNOME_PROPERTY_BOX(prefs_dialog->pbox)->ok_button), "clicked",
			   GTK_SIGNAL_FUNC(prefs_dialog_ok_cb), prefs_dialog);
	gtk_signal_connect(GTK_OBJECT(GNOME_PROPERTY_BOX(prefs_dialog->pbox)->apply_button), "clicked",
			   GTK_SIGNAL_FUNC(prefs_dialog_apply_cb), prefs_dialog);
	gtk_signal_connect_object(GTK_OBJECT(GNOME_PROPERTY_BOX(prefs_dialog->pbox)->cancel_button),
				  "clicked",
				  GTK_SIGNAL_FUNC(gtk_widget_destroy), GTK_OBJECT(prefs_dialog->pbox));

	label = gtk_label_new(_("Playing"));
	gtk_notebook_append_page(GTK_NOTEBOOK (GNOME_PROPERTY_BOX (prefs_dialog->pbox)->notebook), 
				 prefs_dialog_create_playing_page (prefs_dialog), label);
	label = gtk_label_new(_("Filtering"));
	gtk_notebook_append_page(GTK_NOTEBOOK (GNOME_PROPERTY_BOX (prefs_dialog->pbox)->notebook), 
				 prefs_dialog_create_filtering_page (prefs_dialog), label);
	
	/*
       	label = gtk_label_new(_("Output"));
	gtk_notebook_append_page(GTK_NOTEBOOK(GNOME_PROPERTY_BOX(prefs_dialog->pbox)->notebook),
				 prefs_dialog_create_output_page(prefs_dialog), label);
	*/

	prefs_dialog_set_settings(prefs_dialog);

	gtk_widget_set_sensitive(GNOME_PROPERTY_BOX(prefs_dialog->pbox)->ok_button, FALSE);
	gtk_widget_set_sensitive(GNOME_PROPERTY_BOX(prefs_dialog->pbox)->apply_button, FALSE);
	gtk_widget_set_sensitive(GNOME_PROPERTY_BOX(prefs_dialog->pbox)->help_button, FALSE);

	gtk_widget_show_all(prefs_dialog->pbox);
	
}

void prefs_dialog_open_cb(GtkWidget *widget, gpointer data)
{
	prefs_dialog_open();
}
