/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * GnoWavCut -- a GNOME/GTK+ based RIFF PCM Wave file splitter
 * Copyright (C) 2000 Yoichi Imai <yoichi@silver-forest.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#ifndef __UTILS_H__
#define __UTILS_H__

#define GTK_EVENTS_FLUSH() \
{ \
        while (gtk_events_pending()) \
                gtk_main_iteration(); \
}

void utils_msgbox_error(const gchar *msg);
void utils_msgbox_info(const gchar *msg);
void utils_msgbox_warning(const gchar *msg);

gchar *utils_get_time_from_seconds(int in_sec);
gchar *utils_get_mini_time_from_cur(WaveInfo *wave_info, int cur);
gboolean utils_get_cur_from_mini_time(WaveInfo *wave_info, gchar *time_in, int *cur);

void utils_mini_control_set_sensitive(GnoWavCut *gnowavcut, gboolean bool);
void utils_gnowavcut_if_playing(GnoWavCut *gnowavcut, gboolean bool);

gchar *utils_remove_duplicated_spaces(gchar *str);
gchar **utils_get_command_array(gchar *command_line, gchar *filename);
#endif /* __UTILS_H__ */
