#
# Copyright 2001-2005 Free Software Foundation
#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# FILE:
# GridPane.py
#
# DESCRIPTION:
#
# NOTES:

from wxPython.wx import *
import sys, string
from gnue.designer.forms.LayoutEditor.Utils import *
from gnue.common.apps import GDebug


#
#
#
class GridPane(wxSashWindow):
  def __init__(self, instance, parent, pos):
    wxSashWindow.__init__(self, parent, -1, pos=pos, style=wxWANTS_CHARS|wxSIMPLE_BORDER)
    self.__showGrids = 1
    self.__instance = instance
    EVT_PAINT(self, self.OnPaint)

    # TODO: Have the sash events resize the form
    self.SetSashVisible(wxSASH_RIGHT,1)
    self.SetSashVisible(wxSASH_BOTTOM,1)

    EVT_SASH_DRAGGED(self, self.GetId(), self.SashChanged)

  def OnPaint(self, event):
    if self.__showGrids:
      dc = wxPaintDC(self)
      dc.BeginDrawing()
      w, h = self.GetSizeTuple()
      dc.SetPen(wxPen(self.__instance.panelGridColor))
      for x in range(self.__instance.widgetWidth,w-3, self.__instance.widgetWidth):
        dc.DrawLine(x,0,x,h-1)

      for y in range(self.__instance.widgetHeight,h-2,self.__instance.widgetHeight):
        dc.DrawLine(0,y,w-1,y)
      dc.EndDrawing()
    event.Skip()

  def SashChanged(self, event):
    w = event.GetDragRect().width
    h = event.GetDragRect().height

    neww = int(w/float(self.__instance.widgetWidth)+.5)
    newh = int(h/float(self.__instance.widgetHeight)+.5)

    layout = self.__instance.instance.rootObject._layout

    oldvars = {}
    newvars = {}

    if neww != layout.Char__width:
      oldvars['Char:width'] = layout.Char__width
      newvars['Char:width'] = neww
      layout.Char__width = neww
    if newh != layout.Char__height:
      oldvars['Char:height'] = layout.Char__height
      newvars['Char:height'] = newh
      layout.Char__height = newh

    if oldvars:
      self.__instance.instance.dispatchEvent('ObjectModified', object=layout,
                                    originator="Forms::GridPane",
                                    old=oldvars,
                                    new=newvars)

