#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2001-2005 Free Software Foundation
#
# FILE:
# forms/wizards/AddPage.py
#
# DESCRIPTION:
# Adds a blank page to the form
#
# NOTES:
#

from gnue.designer.forms.TemplateSupport import *
from gnue.designer import VERSION
import string

#
# Steps
#
# 0. Get Title             Goto step 1
# 1. Select Connection     Goto step 2
# 2. Select Table          Goto step 3
# 3. Select Fields         Goto step 4 or 7
# 4. Select Master         Goto step 5
# 5. Select Master Keys    Goto step 6
# 6. Select Detail Keys    Goto step 7
# 7. Add another?          Goto step 1,2, or 8
# 8. Complete.
#


class AddPageWizard(FormTemplate):


  # The first step in our wizard.
  # The template parser will initially
  # call GetStep(FIRST_STEP).
  FIRST_STEP = '0'


  ###############
  #
  # Initialize any runtime variables
  #
  def Start(self, root, current):
    self.form = root
    self.current = current




  ###############
  #
  # Return the markup for a specific page
  #
  def GetStep(self, step):

    #
    # Step #0 / Get Name
    #
    if step == '0':

      content = [WizardText('This will insert a new page.'),
                 WizardInput('name',label='Object Name:',required=1,size=20),
                 WizardText('The page caption is optional. It is displayed in "tabbed"-style forms as the tab caption.'),
                 WizardInput('name',label='Caption:',size=20)]

      if hasattr(self.form,'tabbed') and self.form.tabbed:
        content.append(WizardInput('caption', label='Tab Caption: ', required=1,
                                          size=20))

      return   { 'title': 'Add Page',
                 'content': content,
                 'prev': None,
                 'next': None }



  ###############
  #
  # Verify contents of current step
  # Return None if no problems, otherwise
  # return a tuple of error message strings
  #
  def ValidateStep(self, stepCode):

    # The Simple wizard uses basic "required"
    # settings in the page markup, so doesn't
    # need any special validation.
    return None



  ###############
  #
  # We have all the data, so generate our form. This
  # is called after the user clicks the "Finish" button.
  # No more user input is allowed at this point.
  #
  def Finalize(self):


    attrs = {'name': self.GetUniqueName(self.variables['name'] or 'Page1')}

    try:
      if attrs['caption']:
        attrs['caption'] = self.variables['caption']
    except KeyError:
      pass

    page = self.AddElement('page', self.current['layout'], attrs)

    return 1



############
#
# Basic information about this template
#
TemplateInformation = {
    'Product': 'forms',
    'BaseClass' : AddPageWizard,
    'BaseID' : 'AddPage',
    'Name' : _('Add Page'),
    'Description' : _('Inserts a blank page'),
    'Version' : VERSION,
    'Author' : 'The GNUe Designer Team',
    'Behavior': WIZARD,
    'MenuLocation' : ('Insert',_('Blank Page'), 201)
}

