#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2001-2005 Free Software Foundation
#
# FILE:
# forms/wizards/AddTable.py
#
# DESCRIPTION:
# Implements a basic form template
#
# NOTES:
#

from gnue.designer.forms.TemplateSupport import *
from gnue.designer import VERSION
import string


class AddTableWizard(FormTemplate):

  # The first step in our wizard.
  # The template parser will initially
  # call GetStep(FIRST_STEP).
  FIRST_STEP = '0'


  ###############
  #
  # Initialize any runtime variables
  #
  def Start(self, root, current):
    self.schema = root
    self.current = current


  ###############
  #
  # Return the markup for a specific page
  #
  def GetStep(self, stepCode):

    #
    # Step #0 / Get Name
    #
    if stepCode == '0':

      content = [WizardText(_('This will insert a new table definition.')),
                 WizardInput('name',label=_('Table Name:'),required=1,size=20) ]

      return   { 'title': _('Add Table'),
                 'content': content,
                 'prev': None,
                 'next': None }


  ###############
  #
  # We have all the data, so generate our widget.
  #
  def Finalize(self):

    attrs = {'name': self.GetUniqueName(self.variables['name'] or 'Table1')}
    # Find form...
    tables = self.current['tables']

    table = self.AddElement('table', tables, attrs)
    self.AddElement('fields', table)
    self.AddElement('constraints', table)
    self.AddElement('indexes', table)

    return 1



############
#
# Basic information about this template
#
TemplateInformation = {
    'Product': 'schema',
    'BaseID' : 'AddTable',
    'BaseClass' : AddTableWizard,
    'Name' : 'Add Table',
    'Description' : 'Creates a Table',
    'Version' : VERSION,
    'Author' : 'The GNUe Designer Team',
    'Behavior': WIZARD,
    'MenuLocation' : ('Insert', _('Table'))
}

