#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it 
# and/or modify it under the terms of the GNU General Public 
# License as published by the Free Software Foundation; either 
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be 
# useful, but WITHOUT ANY WARRANTY; without even the implied 
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2005 Free Software Foundation
#
#
# FILE:
# GFObjects.py
#
# DESCRIPTION:
"""
Logical label support
"""
# NOTES:
#

from GFValue import GFValue

#
#GFLabel
#
class GFLabel(GFValue):
  def __init__(self, parent=None, value=None):
    GFValue.__init__(self, parent, value, 'GFLabel')

    # Default attributes (these may be replaced by parser)
    self.alignment = "left"
    self.Char__height = int(gConfigForms('widgetHeight'))

    # Runtime Variables
    self._inits = [self.initialize]

  def _buildObject(self):
    if not hasattr(self, 'rows') and hasattr(self,'visibleCount'):
      self.rows = self.visibleCount
      del self.visibleCount
    return GFValue._buildObject(self)

  def setValue(self, value):
    if not self._value:
      GFValue.setValue(self,value)

  #
  # Routines called during a phaseInit
  #
  def initialize(self):
    self._block = self.findParentOfType('GFBlock')







