#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2005 Free Software Foundation
#
# FILE:
# uidrivers/html/GFhtmlApp.py
#
# DESCRIPTION:
#
# NOTES:
#

import sys, cgi
from BaseHTTPServer import HTTPServer
from SimpleHTTPServer import SimpleHTTPRequestHandler

from gnue.common import events
from gnue.forms.uidrivers.win32.common import *

_htmlApp = None
_dhtml = {}


def gethtmlApp(uidriver):
  global _htmlApp
  if not _htmlApp:
    _htmlApp = GFhtmlApp(uidriver)
  return _htmlApp


class GFhtmlApp:

  _mainLoop= None
  _MainWindowList = []

  def __init__(self, uidriver):
    self.uidriver = uidriver
    global _dhtml
    global _htmlApp
    self._dhtml = _dhtml
    self._htmlApp = _htmlApp

  def MainLoop (self):
    if self._mainLoop==None:
      self._mainLoop= 1
      print 'BaseHTTPServer started at http://127.0.0.1:8000'
      server = HTTPServer(('',8000), GFRequestHandler)
      server.serve_forever()


class GFRequestHandler(SimpleHTTPRequestHandler):

  def send_head(self):
    self.send_response(200)
    self.send_header("Content-Type", "text/html")
    self.end_headers()

    self.wfile.write(
'''<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" 
"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<body bgcolor="#EFEFEF" style="font-size: 18px; font-family: courier"
<form method="POST" action="http://127.0.0.1:8000">
%s</form></body></html>''' % ''.join([textEncode(_dhtml[key]) for key in _dhtml.keys()]))


  def do_POST(self):
    fs = cgi.FieldStorage(fp=self.rfile,
                          headers={'content-length':int(self.headers["Content-Length"]),
                                   'content-disposition':'form-data'},
                          environ={'REQUEST_METHOD':'POST'})

    if fs.has_key('requestCOMMIT'):
      _htmlApp.uidriver._form._instance.dispatchEvent(events.Event('requestCOMMIT',_form=_htmlApp.uidriver._form))
    elif fs.has_key('requestNEWRECORD'):
      _htmlApp.uidriver._form._instance.dispatchEvent(events.Event('requestNEWRECORD',_form=_htmlApp.uidriver._form))
    elif fs.has_key('requestMARKFORDELETE'):
      _htmlApp.uidriver._form._instance.dispatchEvent(events.Event('requestMARKFORDELETE',_form=_htmlApp.uidriver._form))
    elif fs.has_key('requestFIRSTRECORD'):
      _htmlApp.uidriver._form._instance.dispatchEvent(events.Event('requestFIRSTRECORD',_form=_htmlApp.uidriver._form))
    elif fs.has_key('requestPREVRECORD'):
      _htmlApp.uidriver._form._instance.dispatchEvent(events.Event('requestPREVRECORD',_form=_htmlApp.uidriver._form))
    elif fs.has_key('requestNEXTRECORD'):
      _htmlApp.uidriver._form._instance.dispatchEvent(events.Event('requestNEXTRECORD',_form=_htmlApp.uidriver._form))
    elif fs.has_key('requestLASTRECORD'):
      _htmlApp.uidriver._form._instance.dispatchEvent(events.Event('requestLASTRECORD',_form=_htmlApp.uidriver._form))
    elif fs.has_key('requestRECORDNUMBER'):
      _htmlApp.uidriver._form._instance.dispatchEvent(events.Event('requestRECORDNUMBER',_form=_htmlApp.uidriver._form))
    elif fs.has_key('requestENTERQUERY'):
      _htmlApp.uidriver._form._instance.dispatchEvent(events.Event('requestENTERQUERY',_form=_htmlApp.uidriver._form))
    elif fs.has_key('requestEXECQUERY'):
      _htmlApp.uidriver._form._instance.dispatchEvent(events.Event('requestEXECQUERY',_form=_htmlApp.uidriver._form))
    elif fs.has_key('requestROLLBACK'):
      _htmlApp.uidriver._form._instance.dispatchEvent(events.Event('requestROLLBACK',_form=_htmlApp.uidriver._form))
    elif fs.has_key('requestEXIT'):
      _htmlApp.uidriver._form._instance.dispatchEvent(events.Event('requestEXIT',_form=_htmlApp.uidriver._form))

    self.send_head()
