#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2005 Free Software Foundation
#
# FILE:
# uidrivers/html/widgets/form/widget.py
#
# DESCRIPTION:
#
# NOTES:
#

import string, struct

from gnue.forms.uidrivers.html.widgets._base import UIHelper, HtmlWidget
from gnue.forms.uidrivers.html.MenuBar import MenuBar
from gnue.forms.uidrivers.html.ToolBar import ToolBar
from gnue.forms.uidrivers.html.common import *


class UIForm(UIHelper):

  def __init__(self, event):
    self._uiPageList=[]
    UIHelper.__init__(self, event)
    self.controls = []

  def _createWidget(self, event, spacer):
    object = event.object
    #
    # Size based upon the form definition
    #

    formWidth = int(self._form._layout.Char__width)
    formHeight = int(self._form._layout.Char__height)
    self._visibleSize = (formWidth*self._uiDriver.widgetWidth,
                      formHeight*self._uiDriver.widgetHeight)

    self._formSize = formSize = (formWidth*self._uiDriver.widgetWidth,
                      formHeight*self._uiDriver.widgetHeight)

    dhtml = ""
    if self._form.style == 'dialog':
      newWidget = HtmlWidget(event.container, self._uiDriver, 'DIALOG', dhtml, getNextId())
    else:  
      newWidget = HtmlWidget(event.container, self._uiDriver, 'FORM', dhtml, getNextId())
    self.mainWindow = newWidget
    
    # Add the menu
#    if not self._form._features['GUI:MENUBAR:SUPPRESS']:
#      MenuBar(self._uiDriver, self.mainWindow, self._form)

    # and the Toolbar
    if not self._form._features['GUI:TOOLBAR:SUPPRESS']:
      ToolBar(self._uiDriver, self.mainWindow, self._form)

    dhtml = "<hr/>"
    HtmlWidget(self.mainWindow, self._uiDriver, 'LINE', dhtml, getNextId())

    self._containerToolkitWidget = newWidget
    return newWidget

  def gotoPage(self,event):
    pass

  def _setStatusBar(self,tip, statusValue, insertValue, currentRecord, maxRecord, currentPage, maxPage):
    pass

  def show(self):
    self.mainWindow.Show()

  def showModal(self):
    self.mainWindow.Show()

