#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2005 Free Software Foundation
#
# DESCRIPTION:
# A wxPython based user interface driver for GNUe forms.
#
# NOTES:
#
# $Id: label.py 6851 2005-01-03 20:59:28Z jcater $

from wxPython.wx import *

from gnue.forms.uidrivers.wx.widgets._base import UIHelper
from gnue.forms.uidrivers.wx.common import wxEncode


_alignmentStyle = { 'left'  : wxALIGN_LEFT | wxST_NO_AUTORESIZE,
                    'center': wxALIGN_CENTRE | wxST_NO_AUTORESIZE,
                    'right' : wxALIGN_RIGHT | wxST_NO_AUTORESIZE,
                    }


# =============================================================================
# Wrap an UI layer around a label widget
# =============================================================================
class UILabel(UIHelper):
  """
  Creates a single instance of a label (static text)
  """

  # --------------------------------------------------------------------------
  # Create a button widget
  # --------------------------------------------------------------------------
  def _createWidget(self, event, spacer):
    """
    Creates a new StaticText widget.
    """
    object = event.object
    style = _alignmentStyle[object.alignment]
    newWidget = wxStaticText(event.container, -1, wxEncode(object.text),
                             wxPoint(self.itemX, self.itemY),
                             wxSize(self.itemWidth, self.itemHeight), style)
    return newWidget


# ----------------------------------------------------------------------------
# Configuration data
# ----------------------------------------------------------------------------
configuration = {
    'baseClass'  : UILabel,
    'provides'   : 'GFLabel',
    'container'  : 0,
    }
