#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2005 Free Software Foundation
#
# FILE:
# UIwxpython.py
#
# DESCRIPTION:
# A wxPython based user interface driver for GNUe forms.
#
# NOTES:
#
# $Id: tree.py 6851 2005-01-03 20:59:28Z jcater $

from wxPython.wx import *

from gnue.forms.uidrivers.wx.widgets._base import UIHelper
from gnue.forms.uidrivers.wx.common import wxEncode
from gnue.common import events
from gnue.forms.uidrivers.wx.common import _eventObjTowxWindow, wxEncode, wxDecode
from types import *

import thread

import string

#
# UITree
#
# Widget set specific function that creates a single instance of a tree
#
class UITree(UIHelper):

  def _createWidget(self, event, spacer):
    self._gftree = object = event.object
    app = wx.wxGetApp()
    self._eventHandler = self._sendEvt = event.eventHandler
    self.evtCtrl = object._form._instance.eventController

    self.splitter = wxSplitterWindow (event.container, -1,
                                      wxPoint (object.Char__x * event.widgetWidth,
                                      (object.Char__y + spacer + (spacer*object._gap)) * event.widgetHeight),
                                      wxSize (self.itemWidth, self.itemHeight))

    self.treeWg = wxTreeCtrl (self.splitter, -1)
    self.listWg = wxListCtrl (self.splitter, -1, wxPoint (0, 0), wxSize (0, 0),
                              wxLC_REPORT | wxLC_SINGLE_SEL)
    self.listWg_root = None    # root TreeNode of the current GFTree selection

    self.splitter.SplitVertically (self.treeWg, self.listWg)
    self.splitter.SetMinimumPaneSize (20)

    EVT_TREE_SEL_CHANGED (app, self.treeWg.GetId(),    self._onTreeSelected)
    EVT_TREE_ITEM_ACTIVATED (app, self.treeWg.GetId(), self._onTreeActivated)
    EVT_TREE_ITEM_EXPANDED (app, self.treeWg.GetId(),  self._onTreeExpanded)
    EVT_TREE_ITEM_COLLAPSED (app, self.treeWg.GetId(), self._onTreeCollapsed)

    EVT_LIST_ITEM_SELECTED (app, self.listWg.GetId(), self._onListSelected)

    #EVT_IDLE (self.treeWg, self.__onIdle)

    self.evtCtrl.registerEventListeners ({
		'gftreeItemSelected': self._gfItemSelected,
		'gftreeAppendKids':   self._gfAppendKids,
		'gftreeRemoveKids':   self._gfRemoveKids
		#'gftreeDetailView':   self._gfDetailView
	})

    object.buildTree()

    wx_align = {'left': wxLIST_FORMAT_LEFT,
                'center': wxLIST_FORMAT_CENTER,
                'right': wxLIST_FORMAT_RIGHT }

    # insert description column -- this col is actually not part of
    # the XML widget description. it is a work-around for missing
    # column support in wx-treeviews (as is this whole treeview/listview
    # thingy)
    self.listWg.InsertColumn (0, _("Node"))
    cnr = 1
    for col in object._colList:
      self.listWg.InsertColumn (cnr, col.name, wx_align[col.align])
      cnr = cnr + 1

    return self.treeWg

  #
  # shows the kids of the selected node in TreeView in the ListView
  #
  def showDetail (self, node):
    self.listWg.DeleteAllItems()
    nr = 0
    self.listWg_root = node

    # go though the children
    for item in node.children:
      self.listWg.InsertStringItem (nr, item.desc)

      # add default column -- we always have this one as first column :-)
      self.listWg.SetStringItem (nr, 0, item.desc)

      # add column labels for current item
      cnr = 1
      for col in item.columns:
        label = "n/a"
        if isinstance(col, UnicodeType):
          label = wxEncode (col)
        else:
          label = str (col)
        self.listWg.SetStringItem (nr, cnr, label)
        cnr = cnr + 1

      nr = nr + 1

  #
  # called by gfobj after (sub)tree items are added and need to be displayed
  #
  def _gfAppendKids (self, event):
    if not event.root.getUiObj(): # we don't have a root node... adding it.
      wxroot = self.treeWg.AddRoot (event.root.desc)
      self.treeWg.SetPyData (wxroot, event.root)
      event.root.setUiObj (ui_info (wxroot))

    root = event.root.getUiObj().tree_item
    old = self.treeWg.GetChildrenCount (root, False)

    for gfi in event.kids[old:]:
      wxi = self.treeWg.AppendItem (root, gfi.desc)
      self.treeWg.SetPyData (wxi, gfi)
      gfi.setUiObj (ui_info(wxi))

  #
  # called by gfobj before (sub)tree items are deleted and need to be erased
  #
  def _gfRemoveKids (self, event):
    for gfi in event.root.children:
      self.treeWg.SetPyData (gfi.getUiObj().tree_item, None)

    self.treeWg.DeleteChildren (event.root.getUiObj().tree_item)

  def _gfItemSelected (self, event):
    print "gf item selected!"

  def _onIdle(self, event):
    pass

  #
  # list selected -- select same item in TreeView
  #
  def _onListSelected (self, event):
    node = self.listWg_root.children[event.GetIndex()]
    tsel = self.treeWg.GetSelection()
    if tsel and self.treeWg.GetPyData(tsel) != node:
      self.treeWg.SelectItem (node.getUiObj().tree_item)

  #
  # called when user selects an item -- passes event to gfobj
  #
  def _onTreeSelected (self, event):

    csel = self.treeWg.GetPyData (event.GetItem())

    if csel.children:                      # build detail list
      self.showDetail (csel)
    else:                                  # select item in already built detail list
      if csel.parent != self.listWg_root:  # user switched to another leafnode
        self.showDetail (csel.parent)      # => rebuild detail list
      pass  # wxListCtrl won't give me any function to change selection :-(

    self._sendEvt (events.Event ('uitreeItemSelected',
                   cursel  = self.treeWg.GetPyData (event.GetItem()),
                   lastsel = self.treeWg.GetPyData (event.GetOldItem()),
                   _form   = self._gftree._form))

    #event.Skip() -- don't skip, it actually comes in handy :-)

  #
  # the new, digitally remastered, thx enhanced _onTreeActivated handler :-)
  #
  def _onTreeActivated (self, event):
    #print "activated: ", self.treeWg.GetPyData (event.GetItem()).desc
    thread.start_new_thread (thread_proc, ())
    pass

  #
  # on item expanded/collapsed we need to update the list view
  #
  def _onTreeExpanded (self, event):
    self._sendEvt ('uitreeItemExpanded',
                   node=self.treeWg.GetPyData(event.GetItem()),
                   _form=self._gftree._form)

  def _onTreeCollapsed (self, event):
    self._sendEvt ('uitreeItemCollapsed',
                   node=self.treeWg.GetPyData(event.GetItem()),
                   _form=self._gftree._form)

#
# stores ui specific information about tree nodes
#
class ui_info:
  def __init__ (self, t=None, l=-1):
    self.tree_item  = t
    self.list_index = l

def thread_proc():
  print "foo"

configuration = {
    'baseClass'  : UITree,
    'provides'   : 'GFTree',
    'container'  : 0,
    }
