#!/usr/bin/env python
#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2002-2005 Free Software Foundation
#
# FILE:
# gfd04to05.py
#
# DESCRIPTION:
# The primary data entry widget in forms
#
# NOTES:
#

import sys, time, re, string
from xml.sax import make_parser, handler
from xml.sax import saxutils

def showUsage():
    print """
gfd04to05.py - a tool for converting old style gnue-forms files (version 0.4x and smaller)
Usage: gfd04to05.py <input file> [<output file>]

"""
    sys.exit(1)
    
if (len(sys.argv) not in [2,3]):
    print 'Error: Wrong number of arguments provided!'
    showUsage()

if sys.argv[1]=='--help':
    showUsage()

    
class Forms04Loader(handler.ContentHandler):

    stack = [None]
    root = None

    def __init__(self, out = sys.stdout):
        handler.ContentHandler.__init__(self)


    # ContentHandler methods

    def startElement(self, name, attrs):

        att = {}
        for attr in attrs.keys():
          att[attr] = attrs[attr]

        m = modeler(name, att, self.stack[0])
        self.stack.insert(0,m)
        if not self.root:
          self.root = m

    def endElement(self, name):
      self.stack.pop(0)

    def characters(self, content):
      self.stack[0]._text += content


class modeler:

  def __init__(self, tag, attrs, parent):
    self._tag = tag
    self._children = []
    self._properties = {}
    self._properties.update(attrs)
    self._parent = parent
    self._text = ""
    if parent:
      parent._children.append(self)

  def printTree(self, indent=0):
    print " " * indent * 2, self._tag
    for child in self._children:
      child.printTree(indent+1)

  def walk(self, method, *args, **parms):
    method(self, *args, **parms)
    for child in self._children:
      child.walk(method, *args, **parms)

  def reparent(self, newparent):
    self._parent._children.pop(self._parent._children.index(self))
    newparent._children.append(self)
    self._parent = newparent

  def toXML(self, dest=sys.stdout, gap="  "):
    global fw,fh, tabbed
    if self._tag == 'layout':
      self._properties['width'] = fw
      self._properties['height'] = fh
      if tabbed:
        self._properties['tabbed'] = tabbed

      dest.write('%s<%s xmlns:c="GNUe:Layout:Char"' % (gap[:-2],self._tag))
    else:
      dest.write("%s<%s" % (gap[:-2],self._tag))

    indent = len("%s<%s" % (gap[:-2],self._tag))
    pos = indent
    attrs = self._properties.keys()
    attrs.sort()
    if 'name' in attrs:
      attrs.pop(attrs.index('name'))
      attrs.insert(0,'name')
    for attribute in attrs:
      # skip keys beginning with _
      if attribute[0] == "_":
        continue
      val = self._properties[attribute]
      if attribute in ('x','y','width','height'):
        ns = 'c:'
      else:
        ns = ""
      addl = ' %s%s="%s"' % (ns,attribute, saxutils.escape('%s' % val))
      if len(addl) + pos > 78:
        dest.write("\n" + " " * indent + addl)
        pos = indent
      else:
        dest.write(addl)
        pos += len(addl)

    if len(self._children) or (self._tag == 'trigger' and self._text):
      hasContent = (self._tag == 'trigger' and self._text)
      if hasContent:
        dest.write("><![CDATA[")
        dest.write(self._text)
      else:
        dest.write(">\n")

      for child in self._children:
        child.toXML(dest, gap+"  ")

      if hasContent:
        dest.write("]]></%s>\n" % (self._tag))
      else:
        dest.write("%s</%s>\n" % (gap[:-2], self._tag))

    else:
      dest.write("/>\n")




def initialStuff(object):

  allobjs.append(object)
  object._origparent = object._parent


def getUniqueName(name, history):

  if name not in history:
    history.append(name)
    return name

  index = len(name) - 1

  while index > 0 and '0' <= name[index] <= '9':
    index -= 1

  index += 1
  if index >= len(name):
    start = 1
    base = name
  else:
    start = int(name[index:])
    base = name[:index]

  while "%s%s" % (base, start) in history:
    start += 1

  history.append("%s%s" % (base, start))
  return "%s%s" % (base, start)

def funkyStuff(object):


  # Change <database> to <connection>
  if object._tag == 'database':
    object._tag = 'connection'

  # Change datasource.connection to datasource.database
  elif object._tag == 'datasource':
    try:
      object._properties['connection'] = object._properties['database']
      del object._properties['database']
    except:
      pass

  elif object._tag == 'button':
    # Remove trigger= support on buttons, and create a button
    try:
      named = object._properties['trigger']
      del object._properties['trigger']
      t = modeler('trigger', {'type': 'On-Action','src': named} , object)
    except KeyError: 
      pass
    print object._tag
    print object._parent._tag,
    print object._parent._origparent._tag
    if object._parent._origparent._tag == 'page': 
      object.reparent(object._parent._origparent)
    else: 
      object.reparent(object._parent)

  elif object._tag == 'page':
    # Move pages to the new <layout> tag
    object.reparent(layout)

  elif object._tag == 'block':

    # Move blocks to the new <logic> tag
    object.reparent(logic)

    # Blocks need unique names now... really important
    try:
      name = object._properties['name']
    except:
      name = 'Block1'
    object._properties['name'] = getUniqueName(name, blockNames)

    # No more transparentBlock; set by default
    try:
      del object._properties['transparentBlock']
    except:
      pass

    if object._origparent._properties.has_key('name'):
      triggerReplacements['%s.%s' % (object._origparent._properties['name'],
          name)] = name

  elif object._tag == 'entry':

    # Old <entry> is now <field>
    object._tag = 'field'

    # Entries need unique names now... really important
    try:
      name = object._properties['name']
    except:
      name = 'Entry1'
    object._properties['name'] = getUniqueName(name, entryNames)

    page = object._parent._origparent

    # Deprecated stuff
    if object._properties.has_key('foreign_key'):
      (fk_source, fk_key) = string.split(object._properties['foreign_key'],'.',1)
      del object._properties['foreign_key']
      object._properties['fk_source'] = fk_source
      object._properties['fk_key'] = fk_key
    if object._properties.has_key('foreign_key_description'):
      fk_descr = object._properties['foreign_key_description']
      del object._properties['foreign_key_description']
      object._properties['fk_description'] = fk_descr
    if object._properties.has_key('no_ltrim'):
      del object._properties['no_ltrim']
      object._properties['ltrim'] = 'N'
    if object._properties.has_key('no_rtrim'):
      del object._properties['no_rtrim']
      object._properties['rtrim'] = 'N'



    # Separate the attributes that should be in entry from field
    eattr = {'block': object._parent._properties['name']}
    for attr in object._properties.keys():
      v = object._properties[attr]
      if attr == 'name':
        eattr['field'] = v
      elif attr in ('x','y','width','height','style','hidden','focusorder',
                    'rows','rowSpacer'):
        eattr[attr] = v
        del object._properties[attr]

    # Create a sister <entry>
    entry = modeler('entry', eattr, page)
    
    # Scan for options
    for child in object._children:
      if child._tag in ('options','tip'): 
        child.reparent(entry)
        
  
  # This one MUST be last... any child of a block
  # besides an entry (which was handled earlier)
  # should be reparented to a page
  elif object._parent._tag == 'block' and object._tag != 'trigger':
    object.reparent(object._parent._origparent)
    
    # Block On-Switch triggers are now Post-FocusIn
    try: 
      if object._tag == 'trigger' and object._properties['type'].upper() == 'ON-SWITCH':
        object._properties['type'] = 'POST-FOCUSIN'
    except KeyError: 
      pass


def fixTriggers(object):
  if object._tag != 'trigger' or not len(object._text):
    return

  for old in triggerReplacements.keys():
    new = triggerReplacements[old]
    object._text = re.sub('%s([. =])' % old.replace('.','\\.'), new + '\\1', object._text)

parser = make_parser()
formloader = Forms04Loader()
parser.setContentHandler(formloader)
parser.parse(sys.argv[1])
form = formloader.root

# Force uniqueness as entry/field names are uber-important
entryNames = []

# Ditto
blockNames = []

fw = 40
fh = 12
tabbed = None

allobjs = []
form.walk(initialStuff)
allobjs.pop(0)


triggerReplacements = {}

logic = modeler('logic', {},form)
layout = modeler('layout', {},form)

  # Default width/height
if form._properties.has_key('width'):
  fw = form._properties['width']
  del form._properties['width']
if form._properties.has_key('height'):
  fh = form._properties['height']
  del form._properties['height']
if form._properties.has_key('tabbed'):
  tabbed = form._properties['tabbed']
  del form._properties['tabbed']



for object in allobjs:
  funkyStuff(object)

for object in allobjs:
  fixTriggers(object)

###form.printTree()

location = sys.argv[1]
try:
  dest = sys.argv[2]
except IndexError:
  # Rewrite over main form.. create a backup first....
  f = open(location)
  b = f.read()
  f.close()
  f = open(location + '.ORIG','w')
  f.write(b)
  f.close()
  dest = location

fileHandle = open(dest,'w')

if sys.getdefaultencoding() == 'ascii':
  fileHandle.write('<?xml version="1.0"?>\n\n')
else:
  fileHandle.write('<?xml version="1.0" encoding="%s"?>\n\n' % \
           (sys.getdefaultencoding()))

fileHandle.write('<!--  GNUe Forms 0.5.0 Migration Tool\n      Saved on: %s  -->\n\n' \
       % (time.strftime("%Y-%m-%d %H:%M:%S",time.localtime(time.time()))))

form.toXML(fileHandle)

fileHandle.close()

