#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2002-2005 Free Software Foundation
#
# FILE:
# transforms/file/text.py
#
# DESCRIPTION:
# Basic destination adapter for writing to a text file
#
# NOTES:
#


from gnue.reports.base.GROutputAdapter import DestinationAdapter as Base

class DestinationAdapter(Base):

  #
  # Typically, a transform adapter will call EITHER
  # getOutputHandle or getOutputFile, not both.
  #
  # return a stream handle for outut by
  # the transform adapter
  #
  def getOutputHandle(self):
    self.output = open(self.destination,'wb')
    return self.output

  #
  # return a file name for outut by the
  # transform adapter
  #
  def getOutputFile(self):
    self.output = None
    return self.destination

  #
  # Wrap up
  #
  def close(self, mimetype='plain/text'):
    if self.output:
      self.output.close()

