#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2001-2005 Free Software Foundation
#
# FILE:
# merge-latex.py
#
# DESCRIPTION:
#
# NOTES:
#

from gnue.reports.adapters.filters.MailMerge._merge import MergeBase
import string, sys



class LatexMerge(mailmerge.MergeBase):

  NAME = "LaTex"

  # What "command" separates new records?
  NEWRECORD = "\\newpage\n"

  # The regex description of the beginning and end of the repeatable sections
  HEAD_DELIMITER = r"\\begin\{document\}" + "\n"
  TAIL_DELIMITER = r"\\end\{document\}" + "\n"
  REGEX = r"\A(.*"            \
          + HEAD_DELIMITER \
          + r")(.+)("           \
          + TAIL_DELIMITER \
          + r".*)\Z"
          
  MIMETYPE = 'application/x-latex'

  # Comments...
  COMMENTABLE = 1        # Does this output format support comments?
  COMMENT_BEGIN = "%% "  # The beginning of a comment
  COMMENT_END = "\n"     # The ending of a comment
  MULTILINE_COMMENTS = 0 # Are these multiline comments?

  # Escape special characters
  def escape(self, s):
    if not len(s): return s
    parts = []
    for part in string.split (s,"\\"):
      for char in r'#$%{}&_':
        part = string.replace(part,char,'\\' + char)
      parts.append(part)

    return string.join(parts,r'\ensuremath{\backslash}')


if __name__ == "__main__":
  template = open(sys.argv[1])
  LatexMerge().merge(sys.stdin, template, sys.stdout)
  template.close()
