#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2002-2005 Free Software Foundation
#
# FILE:
# transforms/sablotron/Adapter.py
#
# DESCRIPTION:
# Transforms adapter for sablotron
#
# NOTES:
#

import sys, tempfile

try:
  import PySablot
##  import Sablot  # TODO: Is this needed??
except ImportError:
  print "Unable to load PySablot"
  sys.exit()


from gnue.reports.base.GROutputAdapter import TransformAdapter as Base
from gnue.common.utils.FileUtils import urlize

class TransformAdapter(Base):

  def open(self):
    # We need a temp file for sablotron
    # TODO: check to see if PySablot will take
    # TODO: a file handle as a parameter.
    self.input, self.infile = self.createTempFile()
    return self.input

  def close(self):

    # We are finished with the intermediate file, so
    # close in order for sablotron to be able to open it.
    self.input.close()

    # Get a file for output from the destination adapter.
    outfile = self.destination.getOutputFile()

    # Get the name of the transform script
    try:
      xslfile = self.parameters['template']
    except KeyError:
      raise "Filter configuration file is missing the 'template=' parameter"

    # Let sablotron do its thing
    PySablot.ProcessFiles(urlize(xslfile),urlize(self.infile),urlize(outfile))
##    P = Sablot.Sablot()  # TODO: Is this needed?

    try:
      mimetype = self.parameters['mimetype']
    except:
      mimetype = 'text/plain'


    # Let the destination adapter do its thing
    self.destination.close(mimetype=mimetype)

    # clean up our temp files
    self.deleteTempFile(self.infile)

