#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2005 Free Software Foundation
#
# FILE:
# GRParameters.py
#
# DESCRIPTION:
# Class
#
# NOTES:
#

from gnue.common.definitions.GObjects import *
from gnue.common.datasources import GConditions
import string

#
#
#
class GRParameters (GObj):
  def __init__ (self, parent):
    GObj.__init__(self, parent, type='GRParameters')
    self._parameters = {}
    self._inits = [self.initialize]

  def initialize(self):
    self.findParentOfType('GRReport')._parameters = self

  #
  # Set the parameters actually supplied by the user
  #
  def setUserParameters(self, parameters):
    if parameters == None:
      self._parameters = {}
    else:
      for key in parameters.keys():
        self._parameters[string.lower(key)] = parameters[key]

  #
  # Get a user parameter. If parameter not specified, pull default value
  #
  def getParameter(self, parameter):
    param = string.lower(parameter)
    try:
      return self._parameters[param]
    except KeyError:
      rv = None
      for child in self._children:
        if child._name == param:
          rv = child.default
          self._parameters[param] = rv
          break
    return rv

  #
  # Return an xml markup of the user supplied or default
  # parameters used to run the current report
  #
  def getRunOptionsAsXML(self):
    from xml.sax import saxutils

    xml = ""
    parameters = {}

    for child in self._children:
      if child.default != None:
        parameters[child._name] = child.default

    parameters.update(self._parameters)

    for param in parameters.keys():
      xml += '    <gnue:request-parameter name="%s">%s</gnue:request-parameter>\n' % \
            (param, saxutils.escape ("%s" % parameters [param]))

    return xml

#
#
#
class GRParameter (GObj):
  def __init__ (self, parent):
    GObj.__init__(self, parent, type='GRParameter')
    self.name = ""
    self.required = 0
    self.default = None

  def _buildObject(self):
    self._name = string.lower(self.name)
    return GObj._buildObject(self)



#
#
#
class GRStubParam(GConditions.GCParam):

  def __init__(self, parent=None):
    GConditions.GCParam.__init__(self, parent)
    self._inits.append(self.initialize)
    self._type = self._typestub

  def initialize(self):
    self._parameters = self.findParentOfType('GRReport')._parameters

  def getValue(self):
    val = self._parameters.getParameter(self.name)
    if val is None:
      return ""
    elif self.type == 'number':
      return float(val)
    else:
      return "%s" % val

  def getFormattedValue(self):
    # TODO: Format masks
    val = self._parameters.getParameter(self.name)
    if val is None:
      return ""
    else:
      return "%s" % val


#
# Used by datasource conditionals
#
class GRConditionParam(GRStubParam):
  _typestub = 'GRCParam'
