#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it 
# and/or modify it under the terms of the GNU General Public 
# License as published by the Free Software Foundation; either 
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be 
# useful, but WITHOUT ANY WARRANTY; without even the implied 
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public 
# License along with program; see the file COPYING. If not, 
# write to the Free Software Foundation, Inc., 59 Temple Place 
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2005 Free Software Foundation
#
# FILE:
# GRSortOptions.py
#
# DESCRIPTION:
# Class 
#
# NOTES:
#
# HISTORY:
#


from gnue.common.definitions.GObjects import *


#
#
#
class GRSortOptions (GObj):

  def __init__(self, parent):
    GObj.__init__(self, parent, type='GRSortOptions')
    self._sortoption = None
    self._default = None

  #
  # Return an xml markup of the user supplied or default
  # sort option used to run the current report
  #
  def getRunOptionsAsXML(self):
    if self.getSortOption() == None:
      return ""
    else:
      return '    <gnue:request-sortoption id="%s"/>\n' % self.getSortOption()

  #
  # Set the sort option to use
  #
  def setSortOption(self, sortoption):
    self._sortoption = sortoption

  #
  # Return the selected sort option
  #
  def getSortOption(self):
    if self._sortoption != None:
      return self._sortoption
    else:
      return self._default

#
#
#
class GRSortOption (GObj):
  def __init__(self, parent):
    GObj.__init__(self, parent, type='GRSortOption')
    self.default = 0

  def _buildObject(self):
    if self.default:
      self.getParent ()._default = self.id
    return GObj._buildObject(self)


#
#
#
class GRSortColumn (GObj):
  def __init__(self, parent):
    GObj.__init__(self, parent, type='GRSortColumn')





