#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2005 Free Software Foundation
#
# FILE:
# GRServer.py
#
# DESCRIPTION:
# Class that defines the RPC interface to the GNUe Reports Server.
#
# NOTES:
#

from gnue.reports.base.GREngine import GREngine
from gnue.reports.base import GRExceptions

class GRRpcHandler:
  def __init__(self, connections):
    self.connections=connections
    
  def requestReportEngine(self):
    return GREngineWrapper(self.connections)


  #
  # List filters available on the server
  #
  def getAvailableFilters(self): 

    # TODO: um, implement??

    return ( ('raw','Do not process the XML with a filter. Emit raw XML.'), )

  #
  # List filters available on the server
  #
  def getAvailableDestinations(self): 

    # TODO: um, implement??

    return ( ('raw','Do not process the XML with a filter. Emit raw XML.'), )

  #
  #  Returns the report definition (in XML format)
  #

  def getReportDefinition(self,location):
    # Parameters: * location <string>   The location of the report
#  def getReportDefinition(self,reportName):
    # Parameters: * location <string>   The location of the report

    pass

  #
  #  Returns the report definition (in XML format)
  #

  def getReportHeader(self,location):
    # Parameters: * location <string>   The location of the report

    pass


  def runReport(self, reportName, sortOption=None, parameters={}):
    pass

  def runReportFromDefinition(self, reportDefinition, sortOption, parameters):
    pass

    
class GREngineWrapper:
  def __init__(self, connections):
    self.__engine = GREngine(connections)
    self.destination = ''
    self.destinationType = ''
    self.destinationOptions = ''
    self.filter = 'raw'
    self.filterOptions = ''

  def setFilter(self, filter,filterOptions):
    self.filter = filter
    self.filterOptions = filterOptions
    
  def setDestination(self, destination, destinationType, destinationOptions):
    if destination == '-':
        raise IOError, "Default destination '-' is not supported by reports server"
    self.destination = destination
    self.destinationType = destinationType
    self.destinationOptions = destinationOptions    
      
  def processReport(self,reportfile,userParameters,sortoption,includeStructuralComments,omitGNUeXML):
    self.__engine.processReport(reportfile, 
                                destination = self.destination,
                                destinationType = self.destinationType,
                                destinationOptions = self.destinationOptions,
                                filter = self.filter,
                                batch = 0,
                                filterOptions = self.filterOptions,
                                parameters=userParameters,
                                sortoption=sortoption,
                                includeStructuralComments=includeStructuralComments,
                                omitGNUeXML=omitGNUeXML)

  def buildReport(self,reportfile,userParameters,sortoption,includeStructuralComments,omitGNUeXML):
      # - create and return a report object
      # - start a thread to run this report
      # - report.status() returns if the report is ready or not
      # - report.fetch() could return report results
      pass

  def clear(self):
    pass
    # remove me
      
