#!/usr/bin/env python
#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2003-2005 Free Software Foundation
#
# FILE:
# create-ppd-classes.py
#
# DESCRIPTION:
#
# NOTES:
#

import sys, string, types, pprint

from gnue.reports.adapters.filters.Universal.postscript.psutils.PrinterDefinition import *


#
# Run this script.  In its own method so we can put long
# strings at the end of this file to make it more readable :)
#
def run(file, name):


  print "Loading %s..." % file
  fm = PrinterDefinition(file)
  outputname = name + '.py'

  print "Saving %s" % outputname
  output = open(outputname,'w')
  output.write(FILEHEADER % locals())
  dumpProperties(fm, output)
  output.write(FILEFOOTER % locals())
  output.close()


pp = pprint.PrettyPrinter(indent=0, width=60)

def dumpProperties(self, output, indent=6):
  # Get the outermost "class" name of object
  # Yes, it's ugly.


  for key, val in self.__dict__.items():
    # conveniently, all PPD properties are capitalized
    if type(key) == types.MethodType:
      continue

    output.write('%s"%s": ' % (' '*indent, key))
    dumpProperty(output, indent, val)

def dumpProperty(output, indent, val, indentprimatives=0):
    if type(val) == types.InstanceType:
      classname = string.split(repr(val))[0].split('.')[-1]

      output.write('%s({\n' % classname)
      dumpProperties(val, output,indent+4)
      output.write('%s    }),\n' % (' '*indent))

    elif type(val) == types.ListType:
      output.write('[\n')
      for prop in val:
        dumpProperty(output, indent+4, prop, 1)
      output.write('%s    ],\n' % (' '*indent))

    elif type(val) == types.DictType:
      output.write('{\n')
      for prop, v in val.items():
        output.write('%s"%s": ' % (' '*(indent+4) , prop ))
        dumpProperty(output, indent+8, v, 1)
      output.write('%s    },\n' % (' '*indent))

    elif indentprimatives:
      output.write('%s%s,\n' % (' '*indent, repr(val)))

    else:
      output.write('%s,\n' % repr(val))



FILEHEADER="""#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2003-2005 Free Software Foundation
#
# FILE:
# %(outputname)s
#
# DESCRIPTION:
# Printer definition for "%(name)s"
#
# NOTES:
# This file was automatically generated by
#   reports/utils/create-ppd-classes.py

__all__ = ['%(name)s']

from gnue.reports.adapters.filters.Standard.Base.psutils.PrinterDefinition import *
from gnue.reports.adapters.filters.Standard.Base.psutils.PrinterDefinition \
   import _Property

class %(name)s (PrinterDefinition):
  def __init__(self):
    self.__dict__.update( {
"""

FILEFOOTER = """
    } )

"""




######################################################################
#
#
if __name__ == '__main__':
  try:
    source, outputname = sys.argv[1:]
  except:
    print """\
GNUe Reports / Postscript Driver
Printer Definition Generator

Creates .py files from .ppd files. Intended to be run against a generic
Postscript Printer Definition file.

Syntax:
   %s </path/to/file1.ppd> outputname

"""  % sys.argv[0]
    sys.exit()

  run(source, outputname)
