/*
     This file is part of GNUnet
     (C) 2005 Christian Grothoff (and other contributing authors)

     GNUnet is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published
     by the Free Software Foundation; either version 2, or (at your
     option) any later version.

     GNUnet is distributed in the hope that it will be useful, but
     WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
     General Public License for more details.

     You should have received a copy of the GNU General Public License
     along with GNUnet; see the file COPYING.  If not, write to the
     Free Software Foundation, Inc., 59 Temple Place - Suite 330,
     Boston, MA 02111-1307, USA.
*/

/**
 * @file src/plugins/about/about.c
 * @author Christian Grothoff
 * @author Igor Wronsky
 *
 * This file contains the about dialog.
 */

#include "platform.h"
#include "gnunetgtk_common.h"

/**
 * This displays an about window
 */
void on_about_clicked(GtkWidget *dummy,
		      gpointer data) {
  GtkWidget * ad;
  GladeXML * axml;

  axml
    = glade_xml_new(getGladeFileName(),
		    "aboutDialog",
		    PACKAGE_NAME);
  ad
    = glade_xml_get_widget(axml,
			   "aboutDialog");
  gtk_dialog_run(GTK_DIALOG(ad));
  g_object_unref(axml);
}

void init_about() {
  GtkWidget * tab;

  tab
    = glade_xml_get_widget(getMainXML(),
			   "aboutButton");
  gtk_widget_show(tab);
}

/* end of about.c */
