/*
     This file is part of GNUnet.
     (C) 2005 Christian Grothoff (and other contributing authors)

     GNUnet is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published
     by the Free Software Foundation; either version 2, or (at your
     option) any later version.

     GNUnet is distributed in the hope that it will be useful, but
     WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
     General Public License for more details.

     You should have received a copy of the GNU General Public License
     along with GNUnet; see the file COPYING.  If not, write to the
     Free Software Foundation, Inc., 59 Temple Place - Suite 330,
     Boston, MA 02111-1307, USA.
*/

/**
 * @file src/plugins/fs/fs.h
 * @brief file-sharing globals of gnunet-gtk
 * @author Christian Grothoff
 */

#ifndef GTK_FS_H
#define GTK_FS_H

#include <GNUnet/gnunet_ecrs_lib.h>
#include <GNUnet/gnunet_fsui_lib.h>

enum {
  SEARCH_NAME = 0,
  SEARCH_SIZE,
  SEARCH_HSIZE,
  SEARCH_MIME,
  SEARCH_DESC,
  SEARCH_PIXBUF,
  SEARCH_URI,
  SEARCH_META,
  SEARCH_INTERNAL,
  SEARCH_NUM,
};

enum {
  NS_SEARCH_DESCRIPTION = 0,
  NS_SEARCH_ENCNAME,
  NS_SEARCH_METADATA,
  NS_SEARCH_RATING,
  NS_SEARCH_NUM,
};

enum {
  SER_SUM_NAME = 0,
  SER_SUM_COUNT,
  SER_SUM_URI,
  SER_SUM_NUM
};

enum {
  DOWNLOAD_FILENAME = 0,
  DOWNLOAD_SHORTNAME,
  DOWNLOAD_SIZE,
  DOWNLOAD_HSIZE,
  DOWNLOAD_PROGRESS,
  DOWNLOAD_URISTRING,
  DOWNLOAD_URI,
  DOWNLOAD_TREEPATH,
  DOWNLOAD_DIRPATH,
  DOWNLOAD_NUM
};

enum {
  NAMESPACE_FILENAME = 0,
  NAMESPACE_SIZE,
  NAMESPACE_HSIZE,
  NAMESPACE_URISTRING,
  NAMESPACE_URI,
  NAMESPACE_META,
  NAMESPACE_NUM
};

enum {
  IN_NAMESPACE_FILENAME = 0,
  IN_NAMESPACE_SIZE,
  IN_NAMESPACE_HSIZE,
  IN_NAMESPACE_DESCRIPTION,
  IN_NAMESPACE_MIMETYPE,
  IN_NAMESPACE_LAST_STRING,
  IN_NAMESPACE_NEXT_STRING,
  IN_NAMESPACE_PUB_FREQ_STRING,
  IN_NAMESPACE_PUB_DATE_STRING,
  IN_NAMESPACE_URI,
  IN_NAMESPACE_META,
  IN_NAMESPACE_NUM
};


enum {
  UPLOAD_FILENAME = 0,
  UPLOAD_PROGRESS,
  UPLOAD_URISTRING,
  UPLOAD_NUM
};

enum {
  META_TYPE = 0,
  META_STYPE,
  META_VALUE,
  META_NUM,
};

enum {
  KTYPE_STRING = 0,
  KTYPE_TYPE,
  KTYPE_NUM,
};

extern struct FSUI_Context * ctx;

#endif
