/** 
   EOStoredProcedure.m <title>EOStoredProcedure Class</title>

   Copyright (C) 2000,2002,2003,2004,2005 Free Software Foundation, Inc.

   Author: Mirko Viviani <mirko.viviani@rccr.cremona.it>
   Date: February 2000

   $Revision: 21645 $
   $Date: 2005-08-17 10:07:57 +0200 (Mit, 17 Aug 2005) $

   <abstract></abstract>

   This file is part of the GNUstep Database Library.

   <license>
   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; see the file COPYING.LIB.
   If not, write to the Free Software Foundation,
   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
   </license>
**/

#include "config.h"

RCS_ID("$Id: EOStoredProcedure.m 21645 2005-08-17 08:07:57Z ayers $")

#ifdef GNUSTEP
#include <Foundation/NSException.h>
#include <Foundation/NSEnumerator.h>
#include <Foundation/NSDebug.h>
#else
#include <Foundation/Foundation.h>
#endif

#ifndef GNUSTEP
#include <GNUstepBase/GNUstep.h>
#endif

#include <GNUstepBase/GCObject.h>

#include <EOControl/EODebug.h>
#include <EOControl/EOObserver.h>

#include <EOAccess/EOStoredProcedure.h>
#include <EOAccess/EOAttribute.h>
#include <EOAccess/EOModel.h>


@implementation EOStoredProcedure

- (EOStoredProcedure *)initWithName:(NSString *)name
{
  self = [super init];

  [self setName:name];
  _userInfo = [NSDictionary new];
  _internalInfo = [NSDictionary new];

  return self;
}

- (void)gcDecrementRefCountOfContainedObjects
{
  EOFLOGObjectFnStart();

  EOFLOGObjectLevel(@"gsdb", @"model gcDecrementRefCount");

  [(id)_model gcDecrementRefCount];
  [(id)_arguments gcDecrementRefCount];

  EOFLOGObjectFnStop();
}

- (BOOL)gcIncrementRefCountOfContainedObjects
{
  if (![super gcIncrementRefCountOfContainedObjects])
    return NO;

  [(id)_model gcIncrementRefCount];
  [(id)_arguments gcIncrementRefCount];

  [(id)_model gcIncrementRefCountOfContainedObjects];
  [(id)_arguments gcIncrementRefCountOfContainedObjects];

  return YES;
}

+ (EOStoredProcedure *)storedProcedureWithPropertyList: (NSDictionary *)propertyList 
                                                 owner: (id)owner
{
  return [[[self alloc] initWithPropertyList: propertyList 
			owner: owner] autorelease];
}

- (id)initWithPropertyList: (NSDictionary *)propertyList owner: (id)owner
{
  NSArray *array;
  NSEnumerator *enumerator;
  id attributePList;

  _model = RETAIN(owner);

  [self setName: [propertyList objectForKey: @"name"]];
  [self setExternalName: [propertyList objectForKey: @"externalName"]];
  [self setUserInfo: [propertyList objectForKey: @"userInfo"]];

  if (!_userInfo)
    [self setUserInfo:[propertyList objectForKey:@"userInfo"]];

  array = [propertyList objectForKey:@"attributes"];
  if ([array count])
    {
      _arguments = [[GCMutableArray alloc] initWithCapacity: [array count]];

      enumerator = [array objectEnumerator];
      while ((attributePList = [enumerator nextObject]))
        {
	  EOAttribute *attribute 
	    = [EOAttribute attributeWithPropertyList: attributePList
			   owner: self];
	  [attribute awakeWithPropertyList: attributePList];
	  [(GCMutableArray *)_arguments addObject: attribute];
        }
    }

  return self;
}

- (void)awakeWithPropertyList: (NSDictionary *)propertyList
{
  NSEnumerator *argsEnum;
  EOAttribute *attribute;

  argsEnum = [_arguments objectEnumerator];
  while ((attribute = [argsEnum nextObject]))
    [attribute awakeWithPropertyList: propertyList];
}

- (void)encodeIntoPropertyList: (NSMutableDictionary *)propertyList
{
  unsigned i, count;

  if (_name)
    {
      [propertyList setObject: _name forKey: @"name"];
    }

  if (_externalName)
    {
      [propertyList setObject: _externalName forKey: @"externalName"];
    }

  if (_userInfo)
    {
      [propertyList setObject: _userInfo forKey: @"userInfo"];
    }

  if ((count = [_arguments count]))
    {
      NSMutableArray *attributesPList 
	= [NSMutableArray arrayWithCapacity: count];

      for (i = 0; i < count; i++)
	{
	  NSMutableDictionary *attributePList 
	    = [NSMutableDictionary dictionary];
	  EOAttribute *attribute
	    = [_arguments objectAtIndex: i];

	  [attribute encodeIntoPropertyList: attributePList];
	  [attributesPList addObject: attributePList];
	}

      [propertyList setObject: attributesPList forKey: @"attributes"];
    }
}

- (NSString*) description
{
  NSMutableDictionary *plist;

  plist = [NSMutableDictionary dictionaryWithCapacity: 6];
  [self encodeIntoPropertyList: plist];

  return [plist description];
}

- (NSString *)name
{
  return _name;
}

- (NSString *)externalName
{
  return _externalName;
}

- (EOModel *)model
{
  return _model;
}

- (NSArray *)arguments
{
  return _arguments;
}

- (NSDictionary *)userInfo
{
  return _userInfo;
}

- (void)setName: (NSString *)name
{
  [self willChange];
  ASSIGN(_name, name);
}

- (void)setExternalName: (NSString *)name
{
  [self willChange];
  ASSIGN(_externalName, name);
}

- (void)setArguments: (NSArray *)arguments
{
  [self willChange];
  if ([arguments isKindOfClass: [GCArray class]]
      || [arguments isKindOfClass: [GCMutableArray class]])
    ASSIGN(_arguments, arguments);
  else
    _arguments = [[GCArray alloc] initWithArray: arguments];
}

- (void)setUserInfo: (NSDictionary *)dictionary
{
  [self willChange];
  ASSIGN(_userInfo, dictionary);
}

@end


@implementation EOStoredProcedure (EOModelBeautifier)

- (void)beautifyName
{
  NSArray  *listItems;
  NSString *newString = [NSMutableString string];
  NSString *tmpString;
  unsigned  anz, i;
  
  EOFLOGObjectFnStartOrCond2(@"ModelingClasses", @"EOStoredProcedure");
  
  if ((_name) && ([_name length] > 0))
    {
      listItems = [_name componentsSeparatedByString: @"_"];
      tmpString = [listItems objectAtIndex: 0];
      tmpString = [tmpString lowercaseString];
      newString = [newString stringByAppendingString: tmpString];
      anz = [listItems count];

      for (i = 1; i < anz; i++)
	{
	  tmpString = [listItems objectAtIndex: i];
	  tmpString = [tmpString capitalizedString];
	  newString = [newString stringByAppendingString: tmpString];
	}
 
    NS_DURING
      [self setName: newString];
    NS_HANDLER
      NSLog(@"%@ in Class: EOStoredProcedure , Method: beautifyName >> error : %@",
            [localException name], [localException reason]);
    NS_ENDHANDLER;
  }
  
  EOFLOGObjectFnStopOrCond2(@"ModelingClasses", @"EOStoredProcedure");
}

@end

@implementation EOStoredProcedure (privat)
- (void)_setIsEdited
{
}
@end
